/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.OperandResolver;
import org.apache.poi.ss.formula.eval.StringEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.Fixed2ArgFunction;

public class Roman
extends Fixed2ArgFunction {
    private static final int[] VALUES = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
    private static final String[] ROMAN = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
    private static final String[][] REPLACEMENTS = new String[][]{{"XLV", "VL", "XCV", "VC", "CDL", "LD", "CML", "LM", "CMVC", "LMVL"}, {"CDXC", "LDXL", "CDVC", "LDVL", "CMXC", "LMXL", "XCIX", "VCIV", "XLIX", "VLIV"}, {"XLIX", "IL", "XCIX", "IC", "CDXC", "XD", "CDVC", "XDV", "CDIC", "XDIX", "LMVL", "XMV", "CMIC", "XMIX", "CMXC", "XM"}, {"XDV", "VD", "XDIX", "VDIV", "XMV", "VM", "XMIX", "VMIV"}, {"VDIV", "ID", "VMIV", "IM"}};

    @Override
    public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval numberVE, ValueEval formVE) {
        int form;
        int number;
        try {
            ValueEval ve = OperandResolver.getSingleValue(numberVE, srcRowIndex, srcColumnIndex);
            number = OperandResolver.coerceValueToInt(ve);
        }
        catch (EvaluationException e2) {
            return ErrorEval.VALUE_INVALID;
        }
        if (number < 0) {
            return ErrorEval.VALUE_INVALID;
        }
        if (number > 3999) {
            return ErrorEval.VALUE_INVALID;
        }
        if (number == 0) {
            return new StringEval("");
        }
        try {
            ValueEval ve = OperandResolver.getSingleValue(formVE, srcRowIndex, srcColumnIndex);
            form = OperandResolver.coerceValueToInt(ve);
        }
        catch (EvaluationException e3) {
            return ErrorEval.NUM_ERROR;
        }
        if (form > 4 || form < 0) {
            return ErrorEval.VALUE_INVALID;
        }
        String result = this.integerToRoman(number);
        if (form == 0) {
            return new StringEval(result);
        }
        return new StringEval(this.makeConcise(result, form));
    }

    private String integerToRoman(int number) {
        StringBuilder result = new StringBuilder();
        for (int i2 = 0; i2 < 13; ++i2) {
            while (number >= VALUES[i2]) {
                number -= VALUES[i2];
                result.append(ROMAN[i2]);
            }
        }
        return result.toString();
    }

    public String makeConcise(String input, int form) {
        String result = input;
        for (int i2 = 0; i2 <= form && i2 <= 4 && form > 0; ++i2) {
            if (i2 == 1 && form > 1) continue;
            String[] repl = REPLACEMENTS[i2];
            for (int j2 = 0; j2 < repl.length - 1; j2 += 2) {
                result = result.replace(repl[j2], repl[j2 + 1]);
            }
        }
        return result;
    }
}

