/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

import java.time.DateTimeException;
import org.apache.poi.ss.formula.eval.BlankEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.OperandResolver;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.ArrayFunction;
import org.apache.poi.ss.formula.functions.Fixed1ArgFunction;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.util.StringUtil;

public final class Value
extends Fixed1ArgFunction
implements ArrayFunction {
    private static final int MIN_DISTANCE_BETWEEN_THOUSANDS_SEPARATOR = 4;
    private static final Double ZERO = 0.0;

    @Override
    public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0) {
        ValueEval veText;
        try {
            veText = OperandResolver.getSingleValue(arg0, srcRowIndex, srcColumnIndex);
        }
        catch (EvaluationException e2) {
            return e2.getErrorEval();
        }
        String strText = OperandResolver.coerceValueToString(veText);
        if (veText == BlankEval.instance) {
            return new NumberEval(0.0);
        }
        if (StringUtil.isBlank(strText)) {
            return ErrorEval.VALUE_INVALID;
        }
        Double result = Value.convertTextToNumber(strText);
        if (result == null) {
            result = Value.parseDateTime(strText);
        }
        if (result == null) {
            return ErrorEval.VALUE_INVALID;
        }
        return new NumberEval(result);
    }

    @Override
    public ValueEval evaluateArray(ValueEval[] args, int srcRowIndex, int srcColumnIndex) {
        if (args.length != 1) {
            return ErrorEval.VALUE_INVALID;
        }
        return this.evaluateOneArrayArg(args[0], srcRowIndex, srcColumnIndex, valA -> this.evaluate(srcRowIndex, srcColumnIndex, (ValueEval)valA));
    }

    public static Double convertTextToNumber(String strText) {
        double d2;
        char ch;
        int i2;
        boolean foundCurrency = false;
        boolean foundUnaryPlus = false;
        boolean foundUnaryMinus = false;
        boolean foundPercentage = false;
        int len = strText.length();
        block15: for (i2 = 0; i2 < len && !Character.isDigit(ch = strText.charAt(i2)) && ch != '.'; ++i2) {
            switch (ch) {
                case ' ': {
                    continue block15;
                }
                case '$': {
                    if (foundCurrency) {
                        return null;
                    }
                    foundCurrency = true;
                    continue block15;
                }
                case '+': {
                    if (foundUnaryMinus || foundUnaryPlus) {
                        return null;
                    }
                    foundUnaryPlus = true;
                    continue block15;
                }
                case '-': {
                    if (foundUnaryMinus || foundUnaryPlus) {
                        return null;
                    }
                    foundUnaryMinus = true;
                    continue block15;
                }
                default: {
                    return null;
                }
            }
        }
        if (i2 >= len) {
            if (foundCurrency || foundUnaryMinus || foundUnaryPlus) {
                return null;
            }
            return ZERO;
        }
        boolean foundDecimalPoint = false;
        int lastThousandsSeparatorIndex = Short.MIN_VALUE;
        StringBuilder sb = new StringBuilder(len);
        while (i2 < len) {
            char ch2 = strText.charAt(i2);
            if (Character.isDigit(ch2)) {
                sb.append(ch2);
            } else {
                switch (ch2) {
                    case ' ': {
                        String remainingTextTrimmed = strText.substring(i2).trim();
                        if (remainingTextTrimmed.equals("%")) {
                            foundPercentage = true;
                            break;
                        }
                        if (remainingTextTrimmed.length() <= 0) break;
                        return null;
                    }
                    case '.': {
                        if (foundDecimalPoint) {
                            return null;
                        }
                        if (i2 - lastThousandsSeparatorIndex < 4) {
                            return null;
                        }
                        foundDecimalPoint = true;
                        sb.append('.');
                        break;
                    }
                    case ',': {
                        if (foundDecimalPoint) {
                            return null;
                        }
                        int distanceBetweenThousandsSeparators = i2 - lastThousandsSeparatorIndex;
                        if (distanceBetweenThousandsSeparators < 4) {
                            return null;
                        }
                        lastThousandsSeparatorIndex = i2;
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        if (i2 - lastThousandsSeparatorIndex < 4) {
                            return null;
                        }
                        sb.append(strText.substring(i2));
                        i2 = len;
                        break;
                    }
                    case '%': {
                        foundPercentage = true;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            }
            ++i2;
        }
        if (!foundDecimalPoint && i2 - lastThousandsSeparatorIndex < 4) {
            return null;
        }
        try {
            d2 = Double.parseDouble(sb.toString());
        }
        catch (NumberFormatException e2) {
            return null;
        }
        double result = foundUnaryMinus ? -d2 : d2;
        return foundPercentage ? result / 100.0 : result;
    }

    public static Double parseDateTime(String pText) {
        try {
            return DateUtil.parseDateTime(pText);
        }
        catch (DateTimeException e2) {
            return null;
        }
    }
}

