/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xdgf.usermodel.section.geometry;

import com.microsoft.schemas.office.visio.x2012.main.CellType;
import com.microsoft.schemas.office.visio.x2012.main.RowType;
import java.awt.geom.Path2D;
import org.apache.poi.ooxml.POIXMLException;
import org.apache.poi.xdgf.usermodel.XDGFCell;
import org.apache.poi.xdgf.usermodel.XDGFShape;
import org.apache.poi.xdgf.usermodel.section.geometry.EllipticalArcTo;
import org.apache.poi.xdgf.usermodel.section.geometry.GeometryRow;

public class RelEllipticalArcTo
implements GeometryRow {
    RelEllipticalArcTo _master;
    Double x;
    Double y;
    Double a;
    Double b;
    Double c;
    Double d;
    Boolean deleted;

    public RelEllipticalArcTo(RowType row) {
        if (row.isSetDel()) {
            this.deleted = row.getDel();
        }
        block16: for (CellType cell : row.getCellArray()) {
            String cellName;
            switch (cellName = cell.getN()) {
                case "X": {
                    this.x = XDGFCell.parseDoubleValue(cell);
                    continue block16;
                }
                case "Y": {
                    this.y = XDGFCell.parseDoubleValue(cell);
                    continue block16;
                }
                case "A": {
                    this.a = XDGFCell.parseDoubleValue(cell);
                    continue block16;
                }
                case "B": {
                    this.b = XDGFCell.parseDoubleValue(cell);
                    continue block16;
                }
                case "C": {
                    this.c = XDGFCell.parseDoubleValue(cell);
                    continue block16;
                }
                case "D": {
                    this.d = XDGFCell.parseDoubleValue(cell);
                    continue block16;
                }
                default: {
                    throw new POIXMLException("Invalid cell '" + cellName + "' in RelEllipticalArcTo row");
                }
            }
        }
    }

    public boolean getDel() {
        if (this.deleted != null) {
            return this.deleted;
        }
        return this._master != null && this._master.getDel();
    }

    public Double getX() {
        return this.x == null ? this._master.x : this.x;
    }

    public Double getY() {
        return this.y == null ? this._master.y : this.y;
    }

    public Double getA() {
        return this.a == null ? this._master.a : this.a;
    }

    public Double getB() {
        return this.b == null ? this._master.b : this.b;
    }

    public Double getC() {
        return this.c == null ? this._master.c : this.c;
    }

    public Double getD() {
        return this.d == null ? this._master.d : this.d;
    }

    @Override
    public void setupMaster(GeometryRow row) {
        this._master = (RelEllipticalArcTo)row;
    }

    @Override
    public void addToPath(Path2D.Double path, XDGFShape parent) {
        if (this.getDel()) {
            return;
        }
        double w2 = parent.getWidth();
        double h2 = parent.getHeight();
        double x2 = this.getX() * w2;
        double y2 = this.getY() * h2;
        double a2 = this.getA() * w2;
        double b2 = this.getB() * h2;
        double c2 = this.getC();
        double d2 = this.getD();
        EllipticalArcTo.createEllipticalArc(x2, y2, a2, b2, c2, d2, path);
    }
}

