/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.xwpf.usermodel.BodyType;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFComments;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFSDT;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTComment;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtBlock;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;

public class XWPFComment
implements IBody {
    protected CTComment ctComment;
    protected XWPFComments comments;
    protected XWPFDocument document;
    private List<XWPFParagraph> paragraphs = new ArrayList<XWPFParagraph>();
    private List<XWPFTable> tables = new ArrayList<XWPFTable>();
    private List<IBodyElement> bodyElements = new ArrayList<IBodyElement>();

    public XWPFComment(CTComment ctComment, XWPFComments comments) {
        this.comments = comments;
        this.ctComment = ctComment;
        this.document = comments.getXWPFDocument();
        this.init();
    }

    protected void init() {
        try (XmlCursor cursor = this.ctComment.newCursor();){
            cursor.selectPath("./*");
            while (cursor.toNextSelection()) {
                XmlObject o2 = cursor.getObject();
                if (o2 instanceof CTP) {
                    XWPFParagraph p2 = new XWPFParagraph((CTP)o2, this);
                    this.bodyElements.add(p2);
                    this.paragraphs.add(p2);
                    continue;
                }
                if (o2 instanceof CTTbl) {
                    XWPFTable t2 = new XWPFTable((CTTbl)o2, this, false);
                    this.bodyElements.add(t2);
                    this.tables.add(t2);
                    continue;
                }
                if (!(o2 instanceof CTSdtBlock)) continue;
                XWPFSDT c2 = new XWPFSDT((CTSdtBlock)o2, (IBody)this);
                this.bodyElements.add(c2);
            }
        }
    }

    @Override
    public POIXMLDocumentPart getPart() {
        return this.comments;
    }

    @Override
    public BodyType getPartType() {
        return BodyType.COMMENT;
    }

    @Override
    public List<IBodyElement> getBodyElements() {
        return Collections.unmodifiableList(this.bodyElements);
    }

    @Override
    public List<XWPFParagraph> getParagraphs() {
        return Collections.unmodifiableList(this.paragraphs);
    }

    @Override
    public List<XWPFTable> getTables() {
        return Collections.unmodifiableList(this.tables);
    }

    @Override
    public XWPFParagraph getParagraph(CTP p2) {
        for (XWPFParagraph paragraph : this.paragraphs) {
            if (!paragraph.getCTP().equals(p2)) continue;
            return paragraph;
        }
        return null;
    }

    @Override
    public XWPFTable getTable(CTTbl ctTable) {
        for (XWPFTable table : this.tables) {
            if (table == null) {
                return null;
            }
            if (!table.getCTTbl().equals(ctTable)) continue;
            return table;
        }
        return null;
    }

    @Override
    public XWPFParagraph getParagraphArray(int pos) {
        if (pos >= 0 && pos < this.paragraphs.size()) {
            return this.paragraphs.get(pos);
        }
        return null;
    }

    @Override
    public XWPFTable getTableArray(int pos) {
        if (pos >= 0 && pos < this.tables.size()) {
            return this.tables.get(pos);
        }
        return null;
    }

    @Override
    public XWPFParagraph insertNewParagraph(XmlCursor cursor) {
        if (this.isCursorInCmt(cursor)) {
            String uri = CTP.type.getName().getNamespaceURI();
            String localPart = "p";
            cursor.beginElement(localPart, uri);
            cursor.toParent();
            CTP p2 = (CTP)cursor.getObject();
            XWPFParagraph newP = new XWPFParagraph(p2, this);
            XmlObject o2 = null;
            while (!(o2 instanceof CTP) && cursor.toPrevSibling()) {
                o2 = cursor.getObject();
            }
            if (!(o2 instanceof CTP) || o2 == p2) {
                this.paragraphs.add(0, newP);
            } else {
                int pos = this.paragraphs.indexOf(this.getParagraph((CTP)o2)) + 1;
                this.paragraphs.add(pos, newP);
            }
            int i2 = 0;
            try (XmlCursor p22 = p2.newCursor();){
                cursor.toCursor(p22);
            }
            while (cursor.toPrevSibling()) {
                o2 = cursor.getObject();
                if (!(o2 instanceof CTP) && !(o2 instanceof CTTbl)) continue;
                ++i2;
            }
            this.bodyElements.add(i2, newP);
            p22 = p2.newCursor();
            var9_9 = null;
            try {
                cursor.toCursor(p22);
                cursor.toEndToken();
            }
            catch (Throwable throwable) {
                var9_9 = throwable;
                throw throwable;
            }
            finally {
                if (p22 != null) {
                    if (var9_9 != null) {
                        try {
                            p22.close();
                        }
                        catch (Throwable throwable) {
                            var9_9.addSuppressed(throwable);
                        }
                    } else {
                        p22.close();
                    }
                }
            }
            return newP;
        }
        return null;
    }

    private boolean isCursorInCmt(XmlCursor cursor) {
        try (XmlCursor verify = cursor.newCursor();){
            verify.toParent();
            boolean bl = verify.getObject() == this.ctComment;
            return bl;
        }
    }

    @Override
    public XWPFTable insertNewTbl(XmlCursor cursor) {
        if (this.isCursorInCmt(cursor)) {
            String uri = CTTbl.type.getName().getNamespaceURI();
            String localPart = "tbl";
            cursor.beginElement(localPart, uri);
            cursor.toParent();
            CTTbl t2 = (CTTbl)cursor.getObject();
            XWPFTable newT = new XWPFTable(t2, this);
            cursor.removeXmlContents();
            XmlObject o2 = null;
            while (!(o2 instanceof CTTbl) && cursor.toPrevSibling()) {
                o2 = cursor.getObject();
            }
            if (!(o2 instanceof CTTbl)) {
                this.tables.add(0, newT);
            } else {
                int pos = this.tables.indexOf(this.getTable((CTTbl)o2)) + 1;
                this.tables.add(pos, newT);
            }
            int i2 = 0;
            try (XmlCursor cursor2 = t2.newCursor();){
                while (cursor2.toPrevSibling()) {
                    o2 = cursor2.getObject();
                    if (!(o2 instanceof CTP) && !(o2 instanceof CTTbl)) continue;
                    ++i2;
                }
            }
            this.bodyElements.add(i2, newT);
            cursor2 = t2.newCursor();
            var9_9 = null;
            try {
                cursor.toCursor(cursor2);
                cursor.toEndToken();
            }
            catch (Throwable throwable) {
                var9_9 = throwable;
                throw throwable;
            }
            finally {
                if (cursor2 != null) {
                    if (var9_9 != null) {
                        try {
                            cursor2.close();
                        }
                        catch (Throwable throwable) {
                            var9_9.addSuppressed(throwable);
                        }
                    } else {
                        cursor2.close();
                    }
                }
            }
            return newT;
        }
        return null;
    }

    @Override
    public void insertTable(int pos, XWPFTable table) {
        this.bodyElements.add(pos, table);
        int i2 = 0;
        for (CTTbl tbl : this.ctComment.getTblList()) {
            if (tbl == table.getCTTbl()) break;
            ++i2;
        }
        this.tables.add(i2, table);
    }

    @Override
    public XWPFTableCell getTableCell(CTTc cell) {
        CTRow row;
        XmlObject o2;
        try (XmlCursor cursor = cell.newCursor();){
            cursor.toParent();
            o2 = cursor.getObject();
            if (!(o2 instanceof CTRow)) {
                XWPFTableCell xWPFTableCell = null;
                return xWPFTableCell;
            }
            row = (CTRow)o2;
            cursor.toParent();
            o2 = cursor.getObject();
        }
        if (!(o2 instanceof CTTbl)) {
            return null;
        }
        CTTbl tbl = (CTTbl)o2;
        XWPFTable table = this.getTable(tbl);
        if (table == null) {
            return null;
        }
        XWPFTableRow tableRow = table.getRow(row);
        return tableRow.getTableCell(cell);
    }

    @Override
    public XWPFDocument getXWPFDocument() {
        return this.document;
    }

    public String getText() {
        StringBuilder text = new StringBuilder();
        for (XWPFParagraph p2 : this.paragraphs) {
            if (text.length() > 0) {
                text.append("\n");
            }
            text.append(p2.getText());
        }
        return text.toString();
    }

    public XWPFParagraph createParagraph() {
        XWPFParagraph paragraph = new XWPFParagraph(this.ctComment.addNewP(), this);
        this.paragraphs.add(paragraph);
        this.bodyElements.add(paragraph);
        return paragraph;
    }

    public void removeParagraph(XWPFParagraph paragraph) {
        if (this.paragraphs.contains(paragraph)) {
            CTP ctP = paragraph.getCTP();
            try (XmlCursor c2 = ctP.newCursor();){
                c2.removeXml();
            }
            this.paragraphs.remove(paragraph);
            this.bodyElements.remove(paragraph);
        }
    }

    public void removeTable(XWPFTable table) {
        if (this.tables.contains(table)) {
            CTTbl ctTbl = table.getCTTbl();
            try (XmlCursor c2 = ctTbl.newCursor();){
                c2.removeXml();
            }
            this.tables.remove(table);
            this.bodyElements.remove(table);
        }
    }

    public XWPFTable createTable(int rows, int cols) {
        XWPFTable table = new XWPFTable(this.ctComment.addNewTbl(), this, rows, cols);
        this.tables.add(table);
        this.bodyElements.add(table);
        return table;
    }

    public CTComment getCtComment() {
        return this.ctComment;
    }

    public XWPFComments getComments() {
        return this.comments;
    }

    public String getId() {
        BigInteger id = this.ctComment.getId();
        return id == null ? "-1" : id.toString();
    }

    public String getAuthor() {
        return this.ctComment.getAuthor();
    }

    public void setAuthor(String author) {
        this.ctComment.setAuthor(author);
    }

    public String getInitials() {
        return this.ctComment.getInitials();
    }

    public void setInitials(String initials) {
        this.ctComment.setInitials(initials);
    }

    public Calendar getDate() {
        return this.ctComment.getDate();
    }

    public void setDate(Calendar date) {
        this.ctComment.setDate(date);
    }
}

