/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.namespace.QName;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.ooxml.POIXMLException;
import org.apache.poi.ooxml.POIXMLTypeLoader;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.xwpf.usermodel.BodyType;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFHeaderFooter;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFSDT;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTNumbering;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtBlock;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.HdrDocument;

public class XWPFHeader
extends XWPFHeaderFooter {
    public XWPFHeader() {
    }

    public XWPFHeader(POIXMLDocumentPart parent, PackagePart part) throws IOException {
        super(parent, part);
    }

    public XWPFHeader(XWPFDocument doc, CTHdrFtr hdrFtr) {
        super(doc, hdrFtr);
        try (XmlCursor cursor = this.headerFooter.newCursor();){
            cursor.selectPath("./*");
            while (cursor.toNextSelection()) {
                XmlObject o2 = cursor.getObject();
                if (o2 instanceof CTP) {
                    XWPFParagraph p2 = new XWPFParagraph((CTP)o2, this);
                    this.paragraphs.add(p2);
                }
                if (!(o2 instanceof CTTbl)) continue;
                XWPFTable t2 = new XWPFTable((CTTbl)o2, this, false);
                this.tables.add(t2);
            }
        }
    }

    @Override
    protected void commit() throws IOException {
        XmlOptions xmlOptions = new XmlOptions(POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
        xmlOptions.setSaveSyntheticDocumentElement(new QName(CTNumbering.type.getName().getNamespaceURI(), "hdr"));
        PackagePart part = this.getPackagePart();
        try (OutputStream out = part.getOutputStream();){
            super._getHdrFtr().save(out, xmlOptions);
        }
    }

    @Override
    protected void onDocumentRead() throws IOException {
        super.onDocumentRead();
        try (InputStream is = this.getPackagePart().getInputStream();){
            HdrDocument hdrDocument = (HdrDocument)HdrDocument.Factory.parse(is, POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
            this.headerFooter = hdrDocument.getHdr();
            try (XmlCursor cursor = this.headerFooter.newCursor();){
                cursor.selectPath("./*");
                while (cursor.toNextSelection()) {
                    XmlObject o2 = cursor.getObject();
                    if (o2 instanceof CTP) {
                        XWPFParagraph p2 = new XWPFParagraph((CTP)o2, this);
                        this.paragraphs.add(p2);
                        this.bodyElements.add(p2);
                    }
                    if (o2 instanceof CTTbl) {
                        XWPFTable t2 = new XWPFTable((CTTbl)o2, this, false);
                        this.tables.add(t2);
                        this.bodyElements.add(t2);
                    }
                    if (!(o2 instanceof CTSdtBlock)) continue;
                    XWPFSDT c2 = new XWPFSDT((CTSdtBlock)o2, (IBody)this);
                    this.bodyElements.add(c2);
                }
            }
        }
        catch (XmlException e2) {
            throw new POIXMLException(e2);
        }
    }

    @Override
    public BodyType getPartType() {
        return BodyType.HEADER;
    }
}

