/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.ICell;
import org.apache.poi.xwpf.usermodel.IRunBody;
import org.apache.poi.xwpf.usermodel.IRunElement;
import org.apache.poi.xwpf.usermodel.ISDTContent;
import org.apache.poi.xwpf.usermodel.ISDTContents;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFSDT;
import org.apache.poi.xwpf.usermodel.XWPFSDTCell;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtBlock;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtContentBlock;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtContentRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtContentRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;

public class XWPFSDTContent
implements ISDTContent {
    private final List<ISDTContents> bodyElements = new ArrayList<ISDTContents>();

    public XWPFSDTContent(CTSdtContentRun sdtRun, IBody part, IRunBody parent) {
        if (sdtRun == null) {
            return;
        }
        try (XmlCursor cursor = sdtRun.newCursor();){
            cursor.selectPath("./*");
            while (cursor.toNextSelection()) {
                XmlObject o2 = cursor.getObject();
                if (o2 instanceof CTR) {
                    XWPFRun run = new XWPFRun((CTR)o2, parent);
                    this.bodyElements.add(run);
                    continue;
                }
                if (!(o2 instanceof CTSdtRun)) continue;
                XWPFSDT c2 = new XWPFSDT((CTSdtRun)o2, part);
                this.bodyElements.add(c2);
            }
        }
    }

    public XWPFSDTContent(CTSdtContentBlock block, IBody part, IRunBody parent) {
        if (block == null) {
            return;
        }
        try (XmlCursor cursor = block.newCursor();){
            cursor.selectPath("./*");
            while (cursor.toNextSelection()) {
                XmlObject o2 = cursor.getObject();
                if (o2 instanceof CTP) {
                    XWPFParagraph p2 = new XWPFParagraph((CTP)o2, part);
                    this.bodyElements.add(p2);
                    continue;
                }
                if (o2 instanceof CTTbl) {
                    XWPFTable t2 = new XWPFTable((CTTbl)o2, part, false);
                    this.bodyElements.add(t2);
                    continue;
                }
                if (o2 instanceof CTSdtBlock) {
                    XWPFSDT c2 = new XWPFSDT((CTSdtBlock)o2, part);
                    this.bodyElements.add(c2);
                    continue;
                }
                if (!(o2 instanceof CTR)) continue;
                XWPFRun run = new XWPFRun((CTR)o2, parent);
                this.bodyElements.add(run);
            }
        }
    }

    public XWPFSDTContent(CTSdtContentRow sdtContentRow, IBody part, IRunBody parent) {
        if (sdtContentRow == null) {
            return;
        }
        try (XmlCursor cursor = sdtContentRow.newCursor();){
            cursor.selectPath("./*");
            while (cursor.toNextSelection()) {
                XmlObject o2 = cursor.getObject();
                if (o2 instanceof CTSdtRow) {
                    XWPFSDT c2 = new XWPFSDT((CTSdtRow)o2, part);
                    this.bodyElements.add(c2);
                    continue;
                }
                if (!(o2 instanceof CTRow)) continue;
            }
        }
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        boolean addNewLine = false;
        for (int i2 = 0; i2 < this.bodyElements.size(); ++i2) {
            ISDTContents o2 = this.bodyElements.get(i2);
            if (o2 instanceof XWPFParagraph) {
                this.appendParagraph((XWPFParagraph)o2, text);
                addNewLine = true;
            } else if (o2 instanceof XWPFTable) {
                this.appendTable((XWPFTable)o2, text);
                addNewLine = true;
            } else if (o2 instanceof XWPFSDT) {
                text.append(((XWPFSDT)o2).getContent().getText());
                addNewLine = true;
            } else if (o2 instanceof XWPFRun) {
                text.append(o2);
                addNewLine = false;
            }
            if (!addNewLine || i2 >= this.bodyElements.size() - 1) continue;
            text.append("\n");
        }
        return text.toString();
    }

    private void appendTable(XWPFTable table, StringBuilder text) {
        for (XWPFTableRow row : table.getRows()) {
            List<ICell> cells = row.getTableICells();
            for (int i2 = 0; i2 < cells.size(); ++i2) {
                ICell cell = cells.get(i2);
                if (cell instanceof XWPFTableCell) {
                    text.append(((XWPFTableCell)cell).getTextRecursively());
                } else if (cell instanceof XWPFSDTCell) {
                    text.append(((XWPFSDTCell)cell).getContent().getText());
                }
                if (i2 >= cells.size() - 1) continue;
                text.append("\t");
            }
            text.append('\n');
        }
    }

    private void appendParagraph(XWPFParagraph paragraph, StringBuilder text) {
        for (IRunElement iRunElement : paragraph.getRuns()) {
            text.append(iRunElement);
        }
    }

    @Override
    public String toString() {
        return this.getText();
    }
}

