/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;

public class XmlRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private List<XmlError> _errors;

    public XmlRuntimeException(String m3) {
        super(m3);
    }

    public XmlRuntimeException(String m3, Throwable t2) {
        super(m3, t2);
    }

    public XmlRuntimeException(Throwable t2) {
        super(t2);
    }

    public XmlRuntimeException(String m3, Throwable t2, Collection<XmlError> errors) {
        super(m3, t2);
        if (errors != null) {
            this._errors = Collections.unmodifiableList(new ArrayList<XmlError>(errors));
        }
    }

    public XmlRuntimeException(XmlError error) {
        this(error.toString(), null, error);
    }

    public XmlRuntimeException(String m3, Throwable t2, XmlError error) {
        this(m3, t2, Collections.singletonList(error));
    }

    public XmlRuntimeException(XmlException xmlException) {
        super(xmlException.getMessage(), xmlException.getCause());
        Collection<XmlError> errors = xmlException.getErrors();
        if (errors != null) {
            this._errors = Collections.unmodifiableList(new ArrayList<XmlError>(errors));
        }
    }

    public XmlError getError() {
        if (this._errors == null || this._errors.size() == 0) {
            return null;
        }
        return this._errors.get(0);
    }

    public Collection<XmlError> getErrors() {
        return this._errors;
    }
}

