/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.common;

import java.io.UnsupportedEncodingException;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.impl.common.QNameHelper;
import org.apache.xmlbeans.impl.common.XmlNameImpl;
import org.apache.xmlbeans.xml.stream.XMLName;

public class XMLNameHelper {
    private static final char[] hexdigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static QName getQName(XMLName xmlName) {
        if (xmlName == null) {
            return null;
        }
        return QNameHelper.forLNS(xmlName.getLocalName(), xmlName.getNamespaceUri());
    }

    public static XMLName forLNS(String localname, String uri) {
        if (uri == null) {
            uri = "";
        }
        return new XmlNameImpl(uri, localname);
    }

    public static XMLName forLN(String localname) {
        return new XmlNameImpl("", localname);
    }

    public static XMLName forPretty(String pretty, int offset) {
        int at = pretty.indexOf(64, offset);
        if (at < 0) {
            return new XmlNameImpl("", pretty.substring(offset));
        }
        return new XmlNameImpl(pretty.substring(at + 1), pretty.substring(offset, at));
    }

    public static String pretty(XMLName name) {
        if (name == null) {
            return "null";
        }
        if (name.getNamespaceUri() == null || name.getNamespaceUri().length() == 0) {
            return name.getLocalName();
        }
        return name.getLocalName() + "@" + name.getNamespaceUri();
    }

    private static boolean isSafe(int c2) {
        if (c2 >= 97 && c2 <= 122) {
            return true;
        }
        if (c2 >= 65 && c2 <= 90) {
            return true;
        }
        return c2 >= 48 && c2 <= 57;
    }

    public static String hexsafe(String s2) {
        StringBuilder result = new StringBuilder();
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            char ch = s2.charAt(i2);
            if (XMLNameHelper.isSafe(ch)) {
                result.append(ch);
                continue;
            }
            byte[] utf8 = null;
            try {
                utf8 = s2.substring(i2, i2 + 1).getBytes("UTF-8");
                for (int j2 = 0; j2 < utf8.length; ++j2) {
                    result.append('_');
                    result.append(hexdigits[utf8[j2] >> 4 & 0xF]);
                    result.append(hexdigits[utf8[j2] & 0xF]);
                }
                continue;
            }
            catch (UnsupportedEncodingException uee) {
                result.append("_BAD_UTF8_CHAR");
            }
        }
        return result.toString();
    }

    public static String hexsafedir(XMLName name) {
        if (name.getNamespaceUri() == null || name.getNamespaceUri().length() == 0) {
            return "_nons/" + XMLNameHelper.hexsafe(name.getLocalName());
        }
        return XMLNameHelper.hexsafe(name.getNamespaceUri()) + "/" + XMLNameHelper.hexsafe(name.getLocalName());
    }
}

