/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.store;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlRuntimeException;
import org.apache.xmlbeans.impl.common.XMLChar;
import org.apache.xmlbeans.impl.soap.Detail;
import org.apache.xmlbeans.impl.soap.DetailEntry;
import org.apache.xmlbeans.impl.soap.MimeHeader;
import org.apache.xmlbeans.impl.soap.Name;
import org.apache.xmlbeans.impl.soap.Node;
import org.apache.xmlbeans.impl.soap.SOAPBody;
import org.apache.xmlbeans.impl.soap.SOAPBodyElement;
import org.apache.xmlbeans.impl.soap.SOAPElement;
import org.apache.xmlbeans.impl.soap.SOAPEnvelope;
import org.apache.xmlbeans.impl.soap.SOAPException;
import org.apache.xmlbeans.impl.soap.SOAPFault;
import org.apache.xmlbeans.impl.soap.SOAPHeader;
import org.apache.xmlbeans.impl.soap.SOAPHeaderElement;
import org.apache.xmlbeans.impl.soap.SOAPPart;
import org.apache.xmlbeans.impl.store.AttrXobj;
import org.apache.xmlbeans.impl.store.CdataNode;
import org.apache.xmlbeans.impl.store.CharNode;
import org.apache.xmlbeans.impl.store.CharUtil;
import org.apache.xmlbeans.impl.store.Cur;
import org.apache.xmlbeans.impl.store.Cursor;
import org.apache.xmlbeans.impl.store.DocumentXobj;
import org.apache.xmlbeans.impl.store.ElementXobj;
import org.apache.xmlbeans.impl.store.Jsr173;
import org.apache.xmlbeans.impl.store.Locale;
import org.apache.xmlbeans.impl.store.NodeXobj;
import org.apache.xmlbeans.impl.store.TextNode;
import org.apache.xmlbeans.impl.store.Xobj;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

public final class DomImpl {
    static final int ELEMENT = 1;
    static final int ATTR = 2;
    static final int TEXT = 3;
    static final int CDATA = 4;
    static final int ENTITYREF = 5;
    static final int ENTITY = 6;
    static final int PROCINST = 7;
    static final int COMMENT = 8;
    static final int DOCUMENT = 9;
    static final int DOCTYPE = 10;
    static final int DOCFRAG = 11;
    static final int NOTATION = 12;
    public static final NodeList _emptyNodeList = new EmptyNodeList();

    static org.w3c.dom.Node parent(Dom d2) {
        return DomImpl.node_getParentNode(d2);
    }

    static org.w3c.dom.Node firstChild(Dom d2) {
        return DomImpl.node_getFirstChild(d2);
    }

    static org.w3c.dom.Node nextSibling(Dom d2) {
        return DomImpl.node_getNextSibling(d2);
    }

    static org.w3c.dom.Node prevSibling(Dom d2) {
        return DomImpl.node_getPreviousSibling(d2);
    }

    public static org.w3c.dom.Node append(Dom n2, Dom p2) {
        return DomImpl.node_insertBefore(p2, n2, null);
    }

    public static org.w3c.dom.Node insert(Dom n2, Dom b2) {
        assert (b2 != null);
        return DomImpl.node_insertBefore((Dom)((Object)DomImpl.parent(b2)), n2, b2);
    }

    public static org.w3c.dom.Node remove(Dom n2) {
        org.w3c.dom.Node p2 = DomImpl.parent(n2);
        if (p2 != null) {
            DomImpl.node_removeChild((Dom)((Object)p2), n2);
        }
        return (org.w3c.dom.Node)((Object)n2);
    }

    static String nodeKindName(int t2) {
        switch (t2) {
            case 2: {
                return "attribute";
            }
            case 4: {
                return "cdata section";
            }
            case 8: {
                return "comment";
            }
            case 11: {
                return "document fragment";
            }
            case 9: {
                return "document";
            }
            case 10: {
                return "document type";
            }
            case 1: {
                return "element";
            }
            case 6: {
                return "entity";
            }
            case 5: {
                return "entity reference";
            }
            case 12: {
                return "notation";
            }
            case 7: {
                return "processing instruction";
            }
            case 3: {
                return "text";
            }
        }
        throw new RuntimeException("Unknown node type");
    }

    private static String isValidChild(Dom parent, Dom child) {
        int pk = parent.nodeType();
        int ck = child.nodeType();
        switch (pk) {
            case 9: {
                switch (ck) {
                    case 1: {
                        if (DomImpl.document_getDocumentElement(parent) != null) {
                            return "Documents may only have a maximum of one document element";
                        }
                        return null;
                    }
                    case 10: {
                        if (DomImpl.document_getDoctype(parent) != null) {
                            return "Documents may only have a maximum of one document type node";
                        }
                        return null;
                    }
                    case 7: 
                    case 8: {
                        return null;
                    }
                }
                break;
            }
            case 2: {
                if (ck != 3 && ck != 5) break;
                return null;
            }
            case 1: 
            case 5: 
            case 6: 
            case 11: {
                switch (ck) {
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: {
                        return null;
                    }
                }
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return DomImpl.nodeKindName(pk) + " nodes may not have any children";
            }
        }
        return DomImpl.nodeKindName(pk) + " nodes may not have " + DomImpl.nodeKindName(ck) + " nodes as children";
    }

    private static void validateNewChild(Dom parent, Dom child) {
        String msg = DomImpl.isValidChild(parent, child);
        if (msg != null) {
            throw new HierarchyRequestErr(msg);
        }
        if (parent == child) {
            throw new HierarchyRequestErr("New child and parent are the same node");
        }
        org.w3c.dom.Node p2 = (org.w3c.dom.Node)((Object)parent);
        while ((p2 = DomImpl.parent((Dom)((Object)p2))) != null) {
            if (child.nodeType() == 5) {
                throw new NoModificationAllowedErr("Entity reference trees may not be modified");
            }
            if (child != p2) continue;
            throw new HierarchyRequestErr("New child is an ancestor node of the parent node");
        }
    }

    private static String validatePrefix(String prefix, String uri, String local, boolean isAttr) {
        if (prefix != null && prefix.contains(":")) {
            throw new NamespaceErr("Invalid prefix - contains ':' character");
        }
        DomImpl.validateNcName(prefix);
        if (prefix == null) {
            prefix = "";
        }
        if (uri == null) {
            uri = "";
        }
        if (prefix.length() > 0 && uri.length() == 0) {
            throw new NamespaceErr("Attempt to give a prefix for no namespace");
        }
        if (prefix.equals("xml") && !uri.equals("http://www.w3.org/XML/1998/namespace")) {
            throw new NamespaceErr("Invalid prefix - begins with 'xml'");
        }
        if (isAttr) {
            if (prefix.length() > 0) {
                if (local.equals("xmlns")) {
                    throw new NamespaceErr("Invalid namespace - attr is default namespace already");
                }
                if (Locale.beginsWithXml(local)) {
                    throw new NamespaceErr("Invalid namespace - attr prefix begins with 'xml'");
                }
                if (prefix.equals("xmlns") && !uri.equals("http://www.w3.org/2000/xmlns/")) {
                    throw new NamespaceErr("Invalid namespace - uri is not 'http://www.w3.org/2000/xmlns/;");
                }
            } else if (local.equals("xmlns") && !uri.equals("http://www.w3.org/2000/xmlns/")) {
                throw new NamespaceErr("Invalid namespace - uri is not 'http://www.w3.org/2000/xmlns/;");
            }
        } else if (Locale.beginsWithXml(prefix)) {
            throw new NamespaceErr("Invalid prefix - begins with 'xml'");
        }
        return prefix;
    }

    private static void validateName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("Name is empty");
        }
        if (!XMLChar.isValidName(name)) {
            throw new InvalidCharacterError("Name has an invalid character");
        }
    }

    private static void validateNcName(String name) {
        if (name != null && name.length() > 0 && !XMLChar.isValidNCName(name)) {
            throw new InvalidCharacterError();
        }
    }

    private static void validateQualifiedName(String name, String uri, boolean isAttr) {
        String local;
        int i2;
        assert (name != null);
        if (uri == null) {
            uri = "";
        }
        if ((i2 = name.indexOf(58)) < 0) {
            local = name;
            DomImpl.validateNcName(local);
            if (isAttr && local.equals("xmlns") && !uri.equals("http://www.w3.org/2000/xmlns/")) {
                throw new NamespaceErr("Default xmlns attribute does not have namespace: http://www.w3.org/2000/xmlns/");
            }
        } else {
            if (i2 == 0) {
                throw new NamespaceErr("Invalid qualified name, no prefix specified");
            }
            String prefix = name.substring(0, i2);
            DomImpl.validateNcName(prefix);
            if (uri.length() == 0) {
                throw new NamespaceErr("Attempt to give a prefix for no namespace");
            }
            local = name.substring(i2 + 1);
            if (local.indexOf(58) >= 0) {
                throw new NamespaceErr("Invalid qualified name, more than one colon");
            }
            DomImpl.validateNcName(local);
            if (prefix.equals("xml") && !uri.equals("http://www.w3.org/XML/1998/namespace")) {
                throw new NamespaceErr("Invalid prefix - begins with 'xml'");
            }
        }
        if (local.length() == 0) {
            throw new NamespaceErr("Invalid qualified name, no local part specified");
        }
    }

    private static void removeNode(Dom n2) {
        CharNode fromNodes;
        assert (n2.nodeType() != 3 && n2.nodeType() != 4);
        Cur cFrom = n2.tempCur();
        cFrom.toEnd();
        if (cFrom.next() && (fromNodes = cFrom.getCharNodes()) != null) {
            cFrom.setCharNodes(null);
            Cur cTo = n2.tempCur();
            cTo.setCharNodes(CharNode.appendNodes(cTo.getCharNodes(), fromNodes));
            cTo.release();
        }
        cFrom.release();
        Cur.moveNode((Xobj)((Object)n2), null);
    }

    public static Document _domImplementation_createDocument(Locale l2, String u2, String n2, DocumentType t2) {
        return DomImpl.syncWrapHelper(l2, true, () -> DomImpl.domImplementation_createDocument(l2, u2, n2, t2));
    }

    public static Document domImplementation_createDocument(Locale l2, String namespaceURI, String qualifiedName, DocumentType doctype) {
        DomImpl.validateQualifiedName(qualifiedName, namespaceURI, false);
        Cur c2 = l2.tempCur();
        c2.createDomDocumentRoot();
        Document doc = (Document)((Object)c2.getDom());
        c2.next();
        c2.createElement(l2.makeQualifiedQName(namespaceURI, qualifiedName));
        if (doctype != null) {
            throw new RuntimeException("Not impl");
        }
        c2.toParent();
        try {
            Locale.autoTypeDocument(c2, null, null);
        }
        catch (XmlException e2) {
            throw new XmlRuntimeException(e2);
        }
        c2.release();
        return doc;
    }

    public static boolean _domImplementation_hasFeature(Locale l2, String feature, String version) {
        if (feature == null) {
            return false;
        }
        if (version != null && version.length() > 0 && !version.equals("1.0") && !version.equals("2.0")) {
            return false;
        }
        if (feature.equalsIgnoreCase("core")) {
            return true;
        }
        return feature.equalsIgnoreCase("xml");
    }

    public static Element _document_getDocumentElement(Dom d2) {
        return DomImpl.syncWrap(d2, DomImpl::document_getDocumentElement);
    }

    public static Element document_getDocumentElement(Dom d2) {
        org.w3c.dom.Node n2 = DomImpl.firstChild(d2);
        while (n2 != null) {
            if (((Dom)((Object)n2)).nodeType() == 1) {
                return (Element)n2;
            }
            n2 = DomImpl.nextSibling((Dom)((Object)n2));
        }
        return null;
    }

    public static DocumentFragment _document_createDocumentFragment(Dom d2) {
        return DomImpl.syncWrap(d2, DomImpl::document_createDocumentFragment);
    }

    public static DocumentFragment document_createDocumentFragment(Dom d2) {
        Cur c2 = d2.locale().tempCur();
        c2.createDomDocFragRoot();
        Dom f2 = c2.getDom();
        c2.release();
        return (DocumentFragment)((Object)f2);
    }

    public static Element _document_createElement(Dom d2, String name) {
        return DomImpl.syncWrap(d2, p2 -> DomImpl.document_createElement(p2, name));
    }

    public static Element document_createElement(Dom d2, String name) {
        DomImpl.validateName(name);
        Locale l2 = d2.locale();
        Cur c2 = l2.tempCur();
        c2.createElement(l2.makeQualifiedQName("", name));
        ElementXobj e2 = (ElementXobj)c2.getDom();
        c2.release();
        e2._canHavePrefixUri = false;
        return e2;
    }

    public static Element _document_createElementNS(Dom d2, String uri, String qname) {
        return DomImpl.syncWrap(d2, p2 -> DomImpl.document_createElementNS(p2, uri, qname));
    }

    public static Element document_createElementNS(Dom d2, String uri, String qname) {
        DomImpl.validateQualifiedName(qname, uri, false);
        Locale l2 = d2.locale();
        Cur c2 = l2.tempCur();
        c2.createElement(l2.makeQualifiedQName(uri, qname));
        Dom e2 = c2.getDom();
        c2.release();
        return (Element)((Object)e2);
    }

    public static Attr _document_createAttribute(Dom d2, String name) {
        return DomImpl.syncWrap(d2, p2 -> DomImpl.document_createAttribute(p2, name));
    }

    public static Attr document_createAttribute(Dom d2, String name) {
        DomImpl.validateName(name);
        Locale l2 = d2.locale();
        Cur c2 = l2.tempCur();
        c2.createAttr(l2.makeQualifiedQName("", name));
        AttrXobj e2 = (AttrXobj)c2.getDom();
        c2.release();
        e2._canHavePrefixUri = false;
        return e2;
    }

    public static Attr _document_createAttributeNS(Dom d2, String uri, String qname) {
        return DomImpl.syncWrap(d2, p2 -> DomImpl.document_createAttributeNS(p2, uri, qname));
    }

    public static Attr document_createAttributeNS(Dom d2, String uri, String qname) {
        DomImpl.validateQualifiedName(qname, uri, true);
        Locale l2 = d2.locale();
        Cur c2 = l2.tempCur();
        c2.createAttr(l2.makeQualifiedQName(uri, qname));
        Dom e2 = c2.getDom();
        c2.release();
        return (Attr)((Object)e2);
    }

    public static Comment _document_createComment(Dom d2, String data) {
        return DomImpl.syncWrap(d2, p2 -> DomImpl.document_createComment(p2, data));
    }

    public static Comment document_createComment(Dom d2, String data) {
        Locale l2 = d2.locale();
        Cur c2 = l2.tempCur();
        c2.createComment();
        Dom comment = c2.getDom();
        if (data != null) {
            c2.next();
            c2.insertString(data);
        }
        c2.release();
        return (Comment)((Object)comment);
    }

    public static ProcessingInstruction _document_createProcessingInstruction(Dom d2, String target, String data) {
        return DomImpl.syncWrap(d2, p2 -> DomImpl.document_createProcessingInstruction(p2, target, data));
    }

    public static ProcessingInstruction document_createProcessingInstruction(Dom d2, String target, String data) {
        if (target == null) {
            throw new IllegalArgumentException("Target is null");
        }
        if (target.length() == 0) {
            throw new IllegalArgumentException("Target is empty");
        }
        if (!XMLChar.isValidName(target)) {
            throw new InvalidCharacterError("Target has an invalid character");
        }
        if (Locale.beginsWithXml(target) && target.length() == 3) {
            throw new InvalidCharacterError("Invalid target - is 'xml'");
        }
        Locale l2 = d2.locale();
        Cur c2 = l2.tempCur();
        c2.createProcinst(target);
        Dom pi = c2.getDom();
        if (data != null) {
            c2.next();
            c2.insertString(data);
        }
        c2.release();
        return (ProcessingInstruction)((Object)pi);
    }

    public static CDATASection _document_createCDATASection(Dom d2, String data) {
        return DomImpl.document_createCDATASection(d2, data);
    }

    public static CDATASection document_createCDATASection(Dom d2, String data) {
        CdataNode t2 = d2.locale().createCdataNode();
        if (data == null) {
            data = "";
        }
        t2.setChars(data, 0, data.length());
        return t2;
    }

    public static Text _document_createTextNode(Dom d2, String data) {
        return DomImpl.document_createTextNode(d2, data);
    }

    public static Text document_createTextNode(Dom d2, String data) {
        TextNode t2 = d2.locale().createTextNode();
        if (data == null) {
            data = "";
        }
        t2.setChars(data, 0, data.length());
        return t2;
    }

    public static EntityReference _document_createEntityReference(Dom d2, String name) {
        throw new RuntimeException("Not implemented");
    }

    public static Element _document_getElementById(Dom d2, String elementId) {
        throw new RuntimeException("Not implemented");
    }

    public static NodeList _document_getElementsByTagName(Dom d2, String name) {
        return DomImpl.syncWrap(d2, p2 -> DomImpl.document_getElementsByTagName(p2, name));
    }

    public static NodeList document_getElementsByTagName(Dom d2, String name) {
        return new ElementsByTagNameNodeList(d2, name);
    }

    public static NodeList _document_getElementsByTagNameNS(Dom d2, String uri, String local) {
        return DomImpl.syncWrap(d2, p2 -> DomImpl.document_getElementsByTagNameNS(p2, uri, local));
    }

    public static NodeList document_getElementsByTagNameNS(Dom d2, String uri, String local) {
        return new ElementsByTagNameNSNodeList(d2, uri, local);
    }

    public static DOMImplementation _document_getImplementation(Dom d2) {
        return d2.locale();
    }

    public static org.w3c.dom.Node _document_importNode(Dom d2, org.w3c.dom.Node n2, boolean deep) {
        return DomImpl.syncWrap(d2, p2 -> DomImpl.document_importNode(p2, n2, deep));
    }

    public static org.w3c.dom.Node document_importNode(Dom d2, org.w3c.dom.Node n2, boolean deep) {
        org.w3c.dom.Node i2;
        if (n2 == null) {
            return null;
        }
        boolean copyChildren = false;
        switch (n2.getNodeType()) {
            case 9: {
                throw new NotSupportedError("Document nodes may not be imported");
            }
            case 10: {
                throw new NotSupportedError("Document type nodes may not be imported");
            }
            case 1: {
                String uri;
                String prefix;
                String local = n2.getLocalName();
                if (local == null || local.length() == 0) {
                    i2 = DomImpl.document_createElement(d2, n2.getNodeName());
                } else {
                    prefix = n2.getPrefix();
                    String name = prefix == null || prefix.length() == 0 ? local : prefix + ":" + local;
                    uri = n2.getNamespaceURI();
                    i2 = uri == null || uri.length() == 0 ? DomImpl.document_createElement(d2, name) : DomImpl.document_createElementNS(d2, uri, name);
                }
                NamedNodeMap attrs = n2.getAttributes();
                for (int a2 = 0; a2 < attrs.getLength(); ++a2) {
                    DomImpl.attributes_setNamedItem((Dom)((Object)i2), (Dom)((Object)DomImpl.document_importNode(d2, attrs.item(a2), true)));
                }
                copyChildren = deep;
                break;
            }
            case 2: {
                String uri;
                String prefix;
                String local = n2.getLocalName();
                if (local == null || local.length() == 0) {
                    i2 = DomImpl.document_createAttribute(d2, n2.getNodeName());
                } else {
                    prefix = n2.getPrefix();
                    String name = prefix == null || prefix.length() == 0 ? local : prefix + ":" + local;
                    uri = n2.getNamespaceURI();
                    i2 = uri == null || uri.length() == 0 ? DomImpl.document_createAttribute(d2, name) : DomImpl.document_createAttributeNS(d2, uri, name);
                }
                copyChildren = true;
                break;
            }
            case 11: {
                i2 = DomImpl.document_createDocumentFragment(d2);
                copyChildren = deep;
                break;
            }
            case 7: {
                i2 = DomImpl.document_createProcessingInstruction(d2, n2.getNodeName(), n2.getNodeValue());
                break;
            }
            case 8: {
                i2 = DomImpl.document_createComment(d2, n2.getNodeValue());
                break;
            }
            case 3: {
                i2 = DomImpl.document_createTextNode(d2, n2.getNodeValue());
                break;
            }
            case 4: {
                i2 = DomImpl.document_createCDATASection(d2, n2.getNodeValue());
                break;
            }
            case 5: 
            case 6: 
            case 12: {
                throw new RuntimeException("Not impl");
            }
            default: {
                throw new RuntimeException("Unknown kind");
            }
        }
        if (copyChildren) {
            NodeList children = n2.getChildNodes();
            for (int c2 = 0; c2 < children.getLength(); ++c2) {
                DomImpl.node_insertBefore((Dom)((Object)i2), (Dom)((Object)DomImpl.document_importNode(d2, children.item(c2), true)), null);
            }
        }
        return i2;
    }

    public static DocumentType _document_getDoctype(Dom d2) {
        return DomImpl.syncWrap(d2, DomImpl::document_getDoctype);
    }

    public static DocumentType document_getDoctype(Dom d2) {
        return null;
    }

    public static Document _node_getOwnerDocument(Dom d2) {
        return DomImpl.syncWrap(d2, DomImpl::node_getOwnerDocument);
    }

    public static Document node_getOwnerDocument(Dom n2) {
        if (n2.nodeType() == 9) {
            return null;
        }
        Locale l2 = n2.locale();
        if (l2._ownerDoc == null) {
            Cur c2 = l2.tempCur();
            c2.createDomDocumentRoot();
            l2._ownerDoc = c2.getDom();
            c2.release();
        }
        return (Document)((Object)l2._ownerDoc);
    }

    public static org.w3c.dom.Node _node_getParentNode(Dom d2) {
        return DomImpl.syncWrap(d2, DomImpl::node_getParentNode);
    }

    public static org.w3c.dom.Node node_getParentNode(Dom n2) {
        Cur c2 = null;
        switch (n2.nodeType()) {
            case 2: 
            case 9: 
            case 11: {
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                c2 = n2.tempCur();
                if (c2.toParentRaw()) break;
                c2.release();
                c2 = null;
                break;
            }
            case 3: 
            case 4: {
                c2 = n2.tempCur();
                if (c2 == null) break;
                c2.toParent();
                break;
            }
            case 5: {
                throw new RuntimeException("Not impl");
            }
            case 6: 
            case 10: 
            case 12: {
                throw new RuntimeException("Not impl");
            }
            default: {
                throw new RuntimeException("Unknown kind");
            }
        }
        if (c2 == null) {
            return null;
        }
        Dom d2 = c2.getDom();
        c2.release();
        return (org.w3c.dom.Node)((Object)d2);
    }

    public static org.w3c.dom.Node _node_getFirstChild(Dom n2) {
        assert (n2 instanceof Xobj);
        Xobj node = (Xobj)((Object)n2);
        if (!node.isVacant()) {
            if (node.isFirstChildPtrDomUsable()) {
                return (org.w3c.dom.Node)((Object)node._firstChild);
            }
            Xobj lastAttr = node.lastAttr();
            if (lastAttr != null && lastAttr.isNextSiblingPtrDomUsable()) {
                return (NodeXobj)lastAttr._nextSibling;
            }
            if (node.isExistingCharNodesValueUsable()) {
                return node._charNodesValue;
            }
        }
        return DomImpl.syncWrapNoEnter(n2, DomImpl::node_getFirstChild);
    }

    public static org.w3c.dom.Node node_getFirstChild(Dom n2) {
        Object fc = null;
        switch (n2.nodeType()) {
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                throw new RuntimeException("Not impl");
            }
            case 6: 
            case 10: 
            case 12: {
                throw new RuntimeException("Not impl");
            }
            case 1: 
            case 2: 
            case 9: 
            case 11: {
                Xobj node = (Xobj)((Object)n2);
                node.ensureOccupancy();
                if (node.isFirstChildPtrDomUsable()) {
                    return (NodeXobj)node._firstChild;
                }
                Xobj lastAttr = node.lastAttr();
                if (lastAttr != null) {
                    if (lastAttr.isNextSiblingPtrDomUsable()) {
                        return (NodeXobj)lastAttr._nextSibling;
                    }
                    if (lastAttr.isCharNodesAfterUsable()) {
                        return lastAttr._charNodesAfter;
                    }
                }
                if (!node.isCharNodesValueUsable()) break;
                return node._charNodesValue;
            }
        }
        return fc;
    }

    public static org.w3c.dom.Node _node_getLastChild(Dom n2) {
        return DomImpl.syncWrap(n2, DomImpl::node_getLastChild);
    }

    public static org.w3c.dom.Node node_getLastChild(Dom n2) {
        CharNode nodes;
        switch (n2.nodeType()) {
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                return null;
            }
            case 5: {
                throw new RuntimeException("Not impl");
            }
            case 6: 
            case 10: 
            case 12: {
                throw new RuntimeException("Not impl");
            }
        }
        Dom lc = null;
        Cur c2 = n2.tempCur();
        if (c2.toLastChild()) {
            lc = c2.getDom();
            c2.skip();
            nodes = c2.getCharNodes();
            if (nodes != null) {
                lc = null;
            }
        } else {
            c2.next();
            nodes = c2.getCharNodes();
        }
        if (lc == null && nodes != null) {
            while (nodes._next != null) {
                nodes = nodes._next;
            }
            lc = nodes;
        }
        c2.release();
        return (org.w3c.dom.Node)((Object)lc);
    }

    public static org.w3c.dom.Node _node_getNextSibling(Dom n2) {
        return DomImpl.syncWrapNoEnter(n2, DomImpl::node_getNextSibling);
    }

    public static org.w3c.dom.Node node_getNextSibling(Dom n2) {
        Dom ns = null;
        switch (n2.nodeType()) {
            case 2: 
            case 9: 
            case 11: {
                break;
            }
            case 3: 
            case 4: {
                CharNode cn = (CharNode)n2;
                if (!(cn.getObject() instanceof Xobj)) {
                    return null;
                }
                Xobj src = (Xobj)cn.getObject();
                src._charNodesAfter = Cur.updateCharNodes(src._locale, src, src._charNodesAfter, src._cchAfter);
                src._charNodesValue = Cur.updateCharNodes(src._locale, src, src._charNodesValue, src._cchValue);
                if (cn._next != null) {
                    ns = cn._next;
                    break;
                }
                boolean isThisNodeAfterText = cn.isNodeAftertext();
                if (isThisNodeAfterText) {
                    ns = (NodeXobj)src._nextSibling;
                    break;
                }
                ns = (NodeXobj)src._firstChild;
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                assert (n2 instanceof Xobj) : "PI, Comments and Elements always backed up by Xobj";
                Xobj node = (Xobj)((Object)n2);
                node.ensureOccupancy();
                if (node.isNextSiblingPtrDomUsable()) {
                    return (NodeXobj)node._nextSibling;
                }
                if (!node.isCharNodesAfterUsable()) break;
                return node._charNodesAfter;
            }
            case 5: 
            case 6: 
            case 10: 
            case 12: {
                throw new RuntimeException("Not implemented");
            }
        }
        return ns;
    }

    public static org.w3c.dom.Node _node_getPreviousSibling(Dom n2) {
        return DomImpl.syncWrapNoEnter(n2, DomImpl::node_getPreviousSibling);
    }

    public static org.w3c.dom.Node node_getPreviousSibling(Dom n2) {
        org.w3c.dom.Node prev;
        switch (n2.nodeType()) {
            case 3: 
            case 4: {
                assert (n2 instanceof CharNode) : "Text/CData should be a CharNode";
                Dom node = (CharNode)n2;
                if (!(((CharNode)node).getObject() instanceof Xobj)) {
                    return null;
                }
                NodeXobj src = (NodeXobj)((CharNode)node).getObject();
                src.ensureOccupancy();
                boolean isThisNodeAfterText = ((CharNode)node).isNodeAftertext();
                prev = ((CharNode)node)._prev;
                if (prev != null) break;
                prev = isThisNodeAfterText ? src : src._charNodesValue;
                break;
            }
            default: {
                assert (n2 instanceof NodeXobj);
                Dom node = (NodeXobj)n2;
                prev = (NodeXobj)((NodeXobj)node)._prevSibling;
                if (prev != null && (node instanceof AttrXobj || !(prev instanceof AttrXobj)) || ((NodeXobj)node)._parent == null) break;
                prev = DomImpl.node_getFirstChild((Dom)((Object)((NodeXobj)node)._parent));
            }
        }
        org.w3c.dom.Node temp = prev;
        while (temp != null && (temp = DomImpl.node_getNextSibling(temp)) != n2) {
            prev = temp;
        }
        return prev;
    }

    public static boolean _node_hasAttributes(Dom n2) {
        return DomImpl.syncWrap(n2, DomImpl::node_hasAttributes);
    }

    public static boolean node_hasAttributes(Dom n2) {
        boolean hasAttrs = false;
        if (n2.nodeType() == 1) {
            Cur c2 = n2.tempCur();
            hasAttrs = c2.hasAttrs();
            c2.release();
        }
        return hasAttrs;
    }

    public static boolean _node_isSupported(Dom n2, String feature, String version) {
        return DomImpl._domImplementation_hasFeature(n2.locale(), feature, version);
    }

    public static void _node_normalize(Dom n2) {
        DomImpl.syncWrapVoid(n2, DomImpl::node_normalize);
    }

    public static void node_normalize(Dom n2) {
        switch (n2.nodeType()) {
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                return;
            }
            case 5: {
                throw new RuntimeException("Not impl");
            }
            case 6: 
            case 10: 
            case 12: {
                throw new RuntimeException("Not impl");
            }
        }
        Cur c2 = n2.tempCur();
        c2.push();
        do {
            c2.nextWithAttrs();
            CharNode cn = c2.getCharNodes();
            if (cn == null) continue;
            if (!c2.isText()) {
                while (cn != null) {
                    cn.setChars(null, 0, 0);
                    cn = CharNode.remove(cn, cn);
                }
            } else if (cn._next != null) {
                while (cn._next != null) {
                    cn.setChars(null, 0, 0);
                    cn = CharNode.remove(cn, cn._next);
                }
                cn._cch = Integer.MAX_VALUE;
            }
            c2.setCharNodes(cn);
        } while (!c2.isAtEndOfLastPush());
        c2.release();
        n2.locale().invalidateDomCaches(n2);
    }

    public static boolean _node_hasChildNodes(Dom n2) {
        return n2 instanceof Xobj && DomImpl._node_getFirstChild(n2) != null;
    }

    public static org.w3c.dom.Node _node_appendChild(Dom p2, org.w3c.dom.Node newChild) {
        return DomImpl._node_insertBefore(p2, newChild, null);
    }

    public static org.w3c.dom.Node _node_replaceChild(Dom p2, org.w3c.dom.Node newChild, org.w3c.dom.Node oldChild) {
        Dom oc;
        Dom nc;
        Locale l2 = p2.locale();
        if (newChild == null) {
            throw new IllegalArgumentException("Child to add is null");
        }
        if (oldChild == null) {
            throw new NotFoundErr("Child to replace is null");
        }
        if (!(newChild instanceof Dom) || (nc = (Dom)((Object)newChild)).locale() != l2) {
            throw new WrongDocumentErr("Child to add is from another document");
        }
        if (!(oldChild instanceof Dom) || (oc = (Dom)((Object)oldChild)).locale() != l2) {
            throw new WrongDocumentErr("Child to replace is from another document");
        }
        Dom oc2 = oc;
        return DomImpl.syncWrap(p2, x2 -> DomImpl.node_replaceChild(x2, nc, oc2));
    }

    public static org.w3c.dom.Node node_replaceChild(Dom p2, Dom newChild, Dom oldChild) {
        org.w3c.dom.Node nextNode = DomImpl.node_getNextSibling(oldChild);
        DomImpl.node_removeChild(p2, oldChild);
        try {
            DomImpl.node_insertBefore(p2, newChild, (Dom)((Object)nextNode));
        }
        catch (DOMException e2) {
            DomImpl.node_insertBefore(p2, oldChild, (Dom)((Object)nextNode));
            throw e2;
        }
        return (org.w3c.dom.Node)((Object)oldChild);
    }

    public static org.w3c.dom.Node _node_insertBefore(Dom p2, org.w3c.dom.Node newChild, org.w3c.dom.Node refChild) {
        Dom nc;
        Locale l2 = p2.locale();
        if (newChild == null) {
            throw new IllegalArgumentException("Child to add is null");
        }
        if (!(newChild instanceof Dom) || (nc = (Dom)((Object)newChild)).locale() != l2) {
            throw new WrongDocumentErr("Child to add is from another document");
        }
        Dom rc = null;
        if (!(refChild == null || refChild instanceof Dom && (rc = (Dom)((Object)refChild)).locale() == l2)) {
            throw new WrongDocumentErr("Reference child is from another document");
        }
        Dom rc2 = rc;
        return DomImpl.syncWrap(p2, x2 -> DomImpl.node_insertBefore(x2, nc, rc2));
    }

    public static org.w3c.dom.Node node_insertBefore(Dom p2, Dom nc, Dom rc) {
        assert (nc != null);
        if (nc == rc) {
            return (org.w3c.dom.Node)((Object)nc);
        }
        if (rc != null && DomImpl.parent(rc) != p2) {
            throw new NotFoundErr("RefChild is not a child of this node");
        }
        int nck = nc.nodeType();
        if (nck == 11) {
            org.w3c.dom.Node c2 = DomImpl.firstChild(nc);
            while (c2 != null) {
                DomImpl.validateNewChild(p2, (Dom)((Object)c2));
                c2 = DomImpl.nextSibling((Dom)((Object)c2));
            }
            org.w3c.dom.Node c3 = DomImpl.firstChild(nc);
            while (c3 != null) {
                org.w3c.dom.Node n2 = DomImpl.nextSibling((Dom)((Object)c3));
                if (rc == null) {
                    DomImpl.append((Dom)((Object)c3), p2);
                } else {
                    DomImpl.insert((Dom)((Object)c3), rc);
                }
                c3 = n2;
            }
            return (org.w3c.dom.Node)((Object)nc);
        }
        DomImpl.validateNewChild(p2, nc);
        DomImpl.remove(nc);
        int pk = p2.nodeType();
        assert (pk == 2 || pk == 11 || pk == 9 || pk == 1);
        switch (nck) {
            case 1: 
            case 7: 
            case 8: {
                if (rc == null) {
                    Cur cTo = p2.tempCur();
                    cTo.toEnd();
                    Cur.moveNode((Xobj)((Object)nc), cTo);
                    cTo.release();
                    break;
                }
                int rck = rc.nodeType();
                if (rck == 3 || rck == 4) {
                    ArrayList<Dom> charNodes = new ArrayList<Dom>();
                    Dom rc2 = rc;
                    while (rc2 != null && (rc2.nodeType() == 3 || rc2.nodeType() == 4)) {
                        org.w3c.dom.Node next = DomImpl.nextSibling(rc2);
                        charNodes.add((Dom)((Object)DomImpl.remove(rc2)));
                        rc2 = (Dom)((Object)next);
                    }
                    if (rc2 == null) {
                        DomImpl.append(nc, p2);
                    } else {
                        DomImpl.insert(nc, rc2);
                    }
                    rc2 = (Dom)((Object)DomImpl.nextSibling(nc));
                    for (Object e2 : charNodes) {
                        Dom n3 = (Dom)e2;
                        if (rc2 == null) {
                            DomImpl.append(n3, p2);
                            continue;
                        }
                        DomImpl.insert(n3, rc2);
                    }
                    break;
                }
                if (rck == 5) {
                    throw new RuntimeException("Not implemented");
                }
                assert (rck == 1 || rck == 7 || rck == 8);
                Cur cTo = rc.tempCur();
                Cur.moveNode((Xobj)((Object)nc), cTo);
                cTo.release();
                break;
            }
            case 3: 
            case 4: {
                CharNode n4 = (CharNode)nc;
                assert (n4._prev == null && n4._next == null);
                CharNode refCharNode = null;
                Cur c3 = p2.tempCur();
                if (rc == null) {
                    c3.toEnd();
                } else {
                    int rck = rc.nodeType();
                    if (rck == 3 || rck == 4) {
                        refCharNode = (CharNode)rc;
                        c3.moveToCharNode(refCharNode);
                    } else {
                        if (rck == 5) {
                            throw new RuntimeException("Not implemented");
                        }
                        c3.moveToDom(rc);
                    }
                }
                CharNode nodes = c3.getCharNodes();
                nodes = CharNode.insertNode(nodes, n4, refCharNode);
                c3.insertChars(n4.getObject(), n4._off, n4._cch);
                c3.setCharNodes(nodes);
                c3.release();
                break;
            }
            case 5: {
                throw new RuntimeException("Not implemented");
            }
            case 10: {
                throw new RuntimeException("Not implemented");
            }
            default: {
                throw new RuntimeException("Unexpected child node type");
            }
        }
        return (org.w3c.dom.Node)((Object)nc);
    }

    public static org.w3c.dom.Node _node_removeChild(Dom p2, org.w3c.dom.Node child) {
        Dom c2;
        Locale l2 = p2.locale();
        if (child == null) {
            throw new NotFoundErr("Child to remove is null");
        }
        if (!(child instanceof Dom) || (c2 = (Dom)((Object)child)).locale() != l2) {
            throw new WrongDocumentErr("Child to remove is from another document");
        }
        return DomImpl.syncWrap(p2, x2 -> DomImpl.node_removeChild(x2, c2));
    }

    public static org.w3c.dom.Node node_removeChild(Dom parent, Dom child) {
        if (DomImpl.parent(child) != parent) {
            throw new NotFoundErr("Child to remove is not a child of given parent");
        }
        switch (child.nodeType()) {
            case 2: 
            case 9: 
            case 11: {
                throw new IllegalStateException();
            }
            case 1: 
            case 7: 
            case 8: {
                DomImpl.removeNode(child);
                break;
            }
            case 3: 
            case 4: {
                Cur c2 = child.tempCur();
                CharNode nodes = c2.getCharNodes();
                CharNode cn = (CharNode)child;
                assert (cn.getDom() != null);
                cn.setChars(c2.moveChars(null, cn._cch), c2._offSrc, c2._cchSrc);
                c2.setCharNodes(CharNode.remove(nodes, cn));
                c2.release();
                break;
            }
            case 5: {
                throw new RuntimeException("Not impl");
            }
            case 6: 
            case 10: 
            case 12: {
                throw new RuntimeException("Not impl");
            }
            default: {
                throw new RuntimeException("Unknown kind");
            }
        }
        return (org.w3c.dom.Node)((Object)child);
    }

    public static org.w3c.dom.Node _node_cloneNode(Dom n2, boolean deep) {
        return DomImpl.syncWrap(n2, p2 -> DomImpl.node_cloneNode(p2, deep));
    }

    public static org.w3c.dom.Node node_cloneNode(Dom n2, boolean deep) {
        Locale l2 = n2.locale();
        Dom clone = null;
        if (!deep) {
            Cur shallow = null;
            switch (n2.nodeType()) {
                case 9: {
                    shallow = l2.tempCur();
                    shallow.createDomDocumentRoot();
                    break;
                }
                case 11: {
                    shallow = l2.tempCur();
                    shallow.createDomDocFragRoot();
                    break;
                }
                case 1: {
                    shallow = l2.tempCur();
                    shallow.createElement(n2.getQName());
                    Element elem = (Element)((Object)shallow.getDom());
                    NamedNodeMap attrs = ((Element)((Object)n2)).getAttributes();
                    for (int i2 = 0; i2 < attrs.getLength(); ++i2) {
                        elem.setAttributeNodeNS((Attr)attrs.item(i2).cloneNode(true));
                    }
                    break;
                }
                case 2: {
                    shallow = l2.tempCur();
                    shallow.createAttr(n2.getQName());
                    break;
                }
            }
            if (shallow != null) {
                clone = shallow.getDom();
                shallow.release();
            }
        }
        if (clone == null) {
            switch (n2.nodeType()) {
                case 1: 
                case 2: 
                case 7: 
                case 8: 
                case 9: 
                case 11: {
                    Cur cClone = l2.tempCur();
                    Cur cSrc = n2.tempCur();
                    cSrc.copyNode(cClone);
                    clone = cClone.getDom();
                    cClone.release();
                    cSrc.release();
                    break;
                }
                case 3: 
                case 4: {
                    Cur c2 = n2.tempCur();
                    TextNode cn = n2.nodeType() == 3 ? l2.createTextNode() : l2.createCdataNode();
                    cn.setChars(c2.getChars(((CharNode)n2)._cch), c2._offSrc, c2._cchSrc);
                    clone = cn;
                    c2.release();
                    break;
                }
                case 5: 
                case 6: 
                case 10: 
                case 12: {
                    throw new RuntimeException("Not impl");
                }
                default: {
                    throw new RuntimeException("Unknown kind");
                }
            }
        }
        return (org.w3c.dom.Node)((Object)clone);
    }

    public static String _node_getLocalName(Dom n2) {
        if (!n2.nodeCanHavePrefixUri()) {
            return null;
        }
        QName name = n2.getQName();
        return name == null ? "" : name.getLocalPart();
    }

    public static String _node_getNamespaceURI(Dom n2) {
        if (!n2.nodeCanHavePrefixUri()) {
            return null;
        }
        QName name = n2.getQName();
        return name == null ? "" : name.getNamespaceURI();
    }

    public static void _node_setPrefix(Dom n2, String prefix) {
        DomImpl.syncWrapVoid(n2, p2 -> DomImpl.node_setPrefix(p2, prefix));
    }

    public static void node_setPrefix(Dom n2, String prefix) {
        if (n2.nodeType() == 1 || n2.nodeType() == 2) {
            Cur c2 = n2.tempCur();
            QName name = c2.getName();
            String uri = name.getNamespaceURI();
            String local = name.getLocalPart();
            prefix = DomImpl.validatePrefix(prefix, uri, local, n2.nodeType() == 2);
            c2.setName(n2.locale().makeQName(uri, local, prefix));
            c2.release();
        } else {
            DomImpl.validatePrefix(prefix, "", "", false);
        }
    }

    public static String _node_getPrefix(Dom n2) {
        if (!n2.nodeCanHavePrefixUri()) {
            return null;
        }
        QName name = n2.getQName();
        return name == null ? "" : name.getPrefix();
    }

    public static String _node_getNodeName(Dom n2) {
        switch (n2.nodeType()) {
            case 4: {
                return "#cdata-section";
            }
            case 8: {
                return "#comment";
            }
            case 11: {
                return "#document-fragment";
            }
            case 9: {
                return "#document";
            }
            case 7: {
                return n2.getQName().getLocalPart();
            }
            case 3: {
                return "#text";
            }
            case 1: 
            case 2: {
                QName name = n2.getQName();
                String prefix = name.getPrefix();
                return prefix.length() == 0 ? name.getLocalPart() : prefix + ":" + name.getLocalPart();
            }
            case 5: 
            case 6: 
            case 10: 
            case 12: {
                throw new RuntimeException("Not impl");
            }
        }
        throw new RuntimeException("Unknown node type");
    }

    public static short _node_getNodeType(Dom n2) {
        return (short)n2.nodeType();
    }

    public static void _node_setNodeValue(Dom n2, String nodeValue) {
        DomImpl.syncWrapVoid(n2, p2 -> DomImpl.node_setNodeValue(p2, nodeValue));
    }

    public static void node_setNodeValue(Dom n2, String nodeValue) {
        if (nodeValue == null) {
            nodeValue = "";
        }
        switch (n2.nodeType()) {
            case 3: 
            case 4: {
                CharNode cn = (CharNode)n2;
                Cur c2 = cn.tempCur();
                if (c2 != null) {
                    c2.moveChars(null, cn._cch);
                    cn._cch = nodeValue.length();
                    c2.insertString(nodeValue);
                    c2.release();
                    break;
                }
                cn.setChars(nodeValue, 0, nodeValue.length());
                break;
            }
            case 2: {
                NodeList children = ((org.w3c.dom.Node)((Object)n2)).getChildNodes();
                while (children.getLength() > 1) {
                    DomImpl.node_removeChild(n2, (Dom)((Object)children.item(1)));
                }
                if (children.getLength() == 0) {
                    TextNode tn = n2.locale().createTextNode();
                    tn.setChars(nodeValue, 0, nodeValue.length());
                    DomImpl.node_insertBefore(n2, tn, null);
                } else {
                    assert (children.getLength() == 1);
                    children.item(0).setNodeValue(nodeValue);
                }
                if (!((AttrXobj)n2).isId()) break;
                Document d2 = DomImpl.node_getOwnerDocument(n2);
                String val = DomImpl.node_getNodeValue(n2);
                if (!(d2 instanceof DocumentXobj)) break;
                DocumentXobj dox = (DocumentXobj)d2;
                dox.removeIdElement(val);
                dox.addIdElement(nodeValue, (Dom)((Object)DomImpl.attr_getOwnerElement(n2)));
                break;
            }
            case 7: 
            case 8: {
                Cur c3 = n2.tempCur();
                c3.next();
                c3.getChars(-1);
                c3.moveChars(null, c3._cchSrc);
                c3.insertString(nodeValue);
                c3.release();
                break;
            }
        }
    }

    public static String _node_getNodeValue(Dom n2) {
        return DomImpl.syncWrapNoEnter(n2, DomImpl::node_getNodeValue);
    }

    public static String node_getNodeValue(Dom n2) {
        String s2 = null;
        switch (n2.nodeType()) {
            case 2: 
            case 7: 
            case 8: {
                s2 = ((Xobj)((Object)n2)).getValueAsString();
                break;
            }
            case 3: 
            case 4: {
                assert (n2 instanceof CharNode) : "Text/CData should be a CharNode";
                CharNode node = (CharNode)n2;
                if (!(node.getObject() instanceof Xobj)) {
                    s2 = CharUtil.getString(node.getObject(), node._off, node._cch);
                    break;
                }
                Xobj src = (Xobj)node.getObject();
                src.ensureOccupancy();
                boolean isThisNodeAfterText = node.isNodeAftertext();
                if (isThisNodeAfterText) {
                    src._charNodesAfter = Cur.updateCharNodes(src._locale, src, src._charNodesAfter, src._cchAfter);
                    s2 = src.getCharsAfterAsString(node._off, node._cch);
                    break;
                }
                src._charNodesValue = Cur.updateCharNodes(src._locale, src, src._charNodesValue, src._cchValue);
                s2 = src.getCharsValueAsString(node._off, node._cch);
                break;
            }
        }
        return s2;
    }

    public static Object _node_getUserData(Dom n2, String key) {
        throw new DomLevel3NotImplemented();
    }

    public static Object _node_setUserData(Dom n2, String key, Object data, UserDataHandler handler) {
        throw new DomLevel3NotImplemented();
    }

    public static Object _node_getFeature(Dom n2, String feature, String version) {
        throw new DomLevel3NotImplemented();
    }

    public static boolean _node_isEqualNode(Dom n2, org.w3c.dom.Node arg) {
        throw new DomLevel3NotImplemented();
    }

    public static boolean _node_isSameNode(Dom n2, org.w3c.dom.Node arg) {
        boolean ret;
        if (n2 instanceof CharNode) {
            ret = n2.equals(arg);
        } else if (n2 instanceof NodeXobj) {
            ret = ((NodeXobj)n2).getDom().equals(arg);
        } else {
            throw new DomLevel3NotImplemented();
        }
        return ret;
    }

    public static String _node_lookupNamespaceURI(Dom n2, String prefix) {
        throw new DomLevel3NotImplemented();
    }

    public static boolean _node_isDefaultNamespace(Dom n2, String namespaceURI) {
        throw new DomLevel3NotImplemented();
    }

    public static String _node_lookupPrefix(Dom n2, String namespaceURI) {
        throw new DomLevel3NotImplemented();
    }

    public static void _node_setTextContent(Dom n2, String textContent) {
        throw new DomLevel3NotImplemented();
    }

    public static String _node_getTextContent(Dom n2) {
        throw new DomLevel3NotImplemented();
    }

    public static short _node_compareDocumentPosition(Dom n2, org.w3c.dom.Node other) {
        org.w3c.dom.Node oAnc;
        org.w3c.dom.Node nAnc;
        boolean isEqual;
        if (!(n2 instanceof org.w3c.dom.Node)) {
            return 32;
        }
        Iterator<org.w3c.dom.Node> nAncIter = DomImpl.ancestorAndSelf((org.w3c.dom.Node)((Object)n2)).iterator();
        Iterator<org.w3c.dom.Node> oAncIter = DomImpl.ancestorAndSelf(other).iterator();
        boolean isFirst = true;
        do {
            nAnc = nAncIter.next();
            oAnc = oAncIter.next();
            isEqual = Objects.equals(nAnc, oAnc);
            if (isFirst && !isEqual) {
                return 1;
            }
            isFirst = false;
        } while (isEqual && nAncIter.hasNext() && oAncIter.hasNext());
        if (isEqual) {
            return (short)(nAncIter.hasNext() ? 10 : (oAncIter.hasNext() ? 20 : 32));
        }
        org.w3c.dom.Node prevSib = nAnc;
        while ((prevSib = prevSib.getPreviousSibling()) != null) {
            if (!Objects.equals(prevSib, oAnc)) continue;
            return 2;
        }
        return 4;
    }

    private static List<org.w3c.dom.Node> ancestorAndSelf(org.w3c.dom.Node node) {
        LinkedList<org.w3c.dom.Node> nodes = new LinkedList<org.w3c.dom.Node>();
        org.w3c.dom.Node n2 = node;
        do {
            nodes.addFirst(n2);
        } while ((n2 = n2.getParentNode()) != null);
        return nodes;
    }

    public static String _node_getBaseURI(Dom n2) {
        throw new DomLevel3NotImplemented();
    }

    public static org.w3c.dom.Node _childNodes_item(Dom n2, int i2) {
        return i2 == 0 ? DomImpl._node_getFirstChild(n2) : DomImpl.syncWrapNoEnter(n2, p2 -> DomImpl.childNodes_item(p2, i2));
    }

    public static org.w3c.dom.Node childNodes_item(Dom n2, int i2) {
        if (i2 < 0) {
            return null;
        }
        switch (n2.nodeType()) {
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                return null;
            }
            case 5: {
                throw new RuntimeException("Not impl");
            }
            case 6: 
            case 10: 
            case 12: {
                throw new RuntimeException("Not impl");
            }
        }
        if (i2 == 0) {
            return DomImpl.node_getFirstChild(n2);
        }
        return (org.w3c.dom.Node)((Object)n2.locale().findDomNthChild(n2, i2));
    }

    public static int _childNodes_getLength(Dom n2) {
        int count;
        assert (n2 instanceof Xobj);
        Xobj node = (Xobj)((Object)n2);
        if (!node.isVacant() && (count = node.getDomZeroOneChildren()) < 2) {
            return count;
        }
        return DomImpl.syncWrapNoEnter(n2, DomImpl::childNodes_getLength);
    }

    public static int childNodes_getLength(Dom n2) {
        switch (n2.nodeType()) {
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                return 0;
            }
            case 5: {
                throw new RuntimeException("Not impl");
            }
            case 6: 
            case 10: 
            case 12: {
                throw new RuntimeException("Not impl");
            }
        }
        assert (n2 instanceof Xobj);
        Xobj node = (Xobj)((Object)n2);
        node.ensureOccupancy();
        int count = node.getDomZeroOneChildren();
        if (count < 2) {
            return count;
        }
        return n2.locale().domLength(n2);
    }

    public static String _element_getTagName(Dom e2) {
        return DomImpl._node_getNodeName(e2);
    }

    public static Attr _element_getAttributeNode(Dom e2, String name) {
        return (Attr)DomImpl._attributes_getNamedItem(e2, name);
    }

    public static Attr _element_getAttributeNodeNS(Dom e2, String uri, String local) {
        return (Attr)DomImpl._attributes_getNamedItemNS(e2, uri, local);
    }

    public static Attr _element_setAttributeNode(Dom e2, Attr newAttr) {
        return (Attr)DomImpl._attributes_setNamedItem(e2, newAttr);
    }

    public static Attr _element_setAttributeNodeNS(Dom e2, Attr newAttr) {
        return (Attr)DomImpl._attributes_setNamedItemNS(e2, newAttr);
    }

    public static String _element_getAttribute(Dom e2, String name) {
        org.w3c.dom.Node a2 = DomImpl._attributes_getNamedItem(e2, name);
        return a2 == null ? "" : a2.getNodeValue();
    }

    public static String _element_getAttributeNS(Dom e2, String uri, String local) {
        org.w3c.dom.Node a2 = DomImpl._attributes_getNamedItemNS(e2, uri, local);
        return a2 == null ? "" : a2.getNodeValue();
    }

    public static boolean _element_hasAttribute(Dom e2, String name) {
        return DomImpl._attributes_getNamedItem(e2, name) != null;
    }

    public static boolean _element_hasAttributeNS(Dom e2, String uri, String local) {
        return DomImpl._attributes_getNamedItemNS(e2, uri, local) != null;
    }

    public static void _element_removeAttribute(Dom e2, String name) {
        try {
            DomImpl._attributes_removeNamedItem(e2, name);
        }
        catch (NotFoundErr notFoundErr) {
            // empty catch block
        }
    }

    public static void _element_removeAttributeNS(Dom e2, String uri, String local) {
        try {
            DomImpl._attributes_removeNamedItemNS(e2, uri, local);
        }
        catch (NotFoundErr notFoundErr) {
            // empty catch block
        }
    }

    public static Attr _element_removeAttributeNode(Dom e2, Attr oldAttr) {
        if (oldAttr == null) {
            throw new NotFoundErr("Attribute to remove is null");
        }
        if (oldAttr.getOwnerElement() != e2) {
            throw new NotFoundErr("Attribute to remove does not belong to this element");
        }
        return (Attr)DomImpl._attributes_removeNamedItem(e2, oldAttr.getNodeName());
    }

    public static void _element_setAttribute(Dom e2, String name, String value) {
        DomImpl.syncWrapVoid(e2, p2 -> DomImpl.element_setAttribute(p2, name, value));
    }

    public static void element_setAttribute(Dom e2, String name, String value) {
        org.w3c.dom.Node a2 = DomImpl.attributes_getNamedItem(e2, name);
        if (a2 == null) {
            Dom e22 = (Dom)((Object)DomImpl.node_getOwnerDocument(e2));
            if (e22 == null) {
                throw new NotFoundErr("Document element can't be determined.");
            }
            a2 = DomImpl.document_createAttribute(e22, name);
            DomImpl.attributes_setNamedItem(e2, (Dom)((Object)a2));
        }
        DomImpl.node_setNodeValue((Dom)((Object)a2), value);
    }

    public static void _element_setAttributeNS(Dom e2, String uri, String qname, String value) {
        DomImpl.syncWrapVoid(e2, p2 -> DomImpl.element_setAttributeNS(p2, uri, qname, value));
    }

    public static void element_setAttributeNS(Dom e2, String uri, String qname, String value) {
        DomImpl.validateQualifiedName(qname, uri, true);
        QName name = e2.locale().makeQualifiedQName(uri, qname);
        String local = name.getLocalPart();
        String prefix = DomImpl.validatePrefix(name.getPrefix(), uri, local, true);
        org.w3c.dom.Node a2 = DomImpl.attributes_getNamedItemNS(e2, uri, local);
        if (a2 == null) {
            a2 = DomImpl.document_createAttributeNS((Dom)((Object)DomImpl.node_getOwnerDocument(e2)), uri, local);
            DomImpl.attributes_setNamedItemNS(e2, (Dom)((Object)a2));
        }
        DomImpl.node_setPrefix((Dom)((Object)a2), prefix);
        DomImpl.node_setNodeValue((Dom)((Object)a2), value);
    }

    public static NodeList _element_getElementsByTagName(Dom e2, String name) {
        return DomImpl.syncWrap(e2, p2 -> DomImpl.element_getElementsByTagName(p2, name));
    }

    public static NodeList element_getElementsByTagName(Dom e2, String name) {
        return new ElementsByTagNameNodeList(e2, name);
    }

    public static NodeList _element_getElementsByTagNameNS(Dom e2, String uri, String local) {
        return DomImpl.syncWrap(e2, p2 -> DomImpl.element_getElementsByTagNameNS(p2, uri, local));
    }

    public static NodeList element_getElementsByTagNameNS(Dom e2, String uri, String local) {
        return new ElementsByTagNameNSNodeList(e2, uri, local);
    }

    public static int _attributes_getLength(Dom e2) {
        return DomImpl.syncWrap(e2, DomImpl::attributes_getLength);
    }

    public static int attributes_getLength(Dom e2) {
        int n2 = 0;
        Cur c2 = e2.tempCur();
        while (c2.toNextAttr()) {
            ++n2;
        }
        c2.release();
        return n2;
    }

    public static org.w3c.dom.Node _attributes_setNamedItem(Dom e2, org.w3c.dom.Node attr) {
        Dom a2;
        Locale l2 = e2.locale();
        if (attr == null) {
            throw new IllegalArgumentException("Attr to set is null");
        }
        if (!(attr instanceof Dom) || (a2 = (Dom)((Object)attr)).locale() != l2) {
            throw new WrongDocumentErr("Attr to set is from another document");
        }
        return DomImpl.syncWrap(e2, p2 -> DomImpl.attributes_setNamedItem(p2, a2));
    }

    public static org.w3c.dom.Node attributes_setNamedItem(Dom e2, Dom a2) {
        if (DomImpl.attr_getOwnerElement(a2) != null) {
            throw new InuseAttributeError();
        }
        if (a2.nodeType() != 2) {
            throw new HierarchyRequestErr("Node is not an attribute");
        }
        String name = DomImpl._node_getNodeName(a2);
        Dom oldAttr = null;
        Cur c2 = e2.tempCur();
        while (c2.toNextAttr()) {
            Dom aa2 = c2.getDom();
            if (!DomImpl._node_getNodeName(aa2).equals(name)) continue;
            if (oldAttr == null) {
                oldAttr = aa2;
                continue;
            }
            DomImpl.removeNode(aa2);
            c2.toPrevAttr();
        }
        if (oldAttr == null) {
            c2.moveToDom(e2);
            c2.next();
            Cur.moveNode((Xobj)((Object)a2), c2);
        } else {
            c2.moveToDom(oldAttr);
            Cur.moveNode((Xobj)((Object)a2), c2);
            DomImpl.removeNode(oldAttr);
        }
        c2.release();
        return (org.w3c.dom.Node)((Object)oldAttr);
    }

    public static org.w3c.dom.Node _attributes_getNamedItem(Dom e2, String name) {
        return DomImpl.syncWrap(e2, p2 -> DomImpl.attributes_getNamedItem(e2, name));
    }

    public static org.w3c.dom.Node attributes_getNamedItem(Dom e2, String name) {
        Dom a2 = null;
        Cur c2 = e2.tempCur();
        while (c2.toNextAttr()) {
            Dom d2 = c2.getDom();
            if (!DomImpl._node_getNodeName(d2).equals(name)) continue;
            a2 = d2;
            break;
        }
        c2.release();
        return (org.w3c.dom.Node)((Object)a2);
    }

    public static org.w3c.dom.Node _attributes_getNamedItemNS(Dom e2, String uri, String local) {
        return DomImpl.syncWrap(e2, p2 -> DomImpl.attributes_getNamedItemNS(p2, uri, local));
    }

    public static org.w3c.dom.Node attributes_getNamedItemNS(Dom e2, String uri, String local) {
        if (uri == null) {
            uri = "";
        }
        Dom a2 = null;
        Cur c2 = e2.tempCur();
        while (c2.toNextAttr()) {
            Dom d2 = c2.getDom();
            QName n2 = d2.getQName();
            if (!n2.getNamespaceURI().equals(uri) || !n2.getLocalPart().equals(local)) continue;
            a2 = d2;
            break;
        }
        c2.release();
        return (org.w3c.dom.Node)((Object)a2);
    }

    public static org.w3c.dom.Node _attributes_removeNamedItem(Dom e2, String name) {
        return DomImpl.syncWrap(e2, p2 -> DomImpl.attributes_removeNamedItem(p2, name));
    }

    public static org.w3c.dom.Node attributes_removeNamedItem(Dom e2, String name) {
        Dom oldAttr = null;
        Cur c2 = e2.tempCur();
        while (c2.toNextAttr()) {
            Dom aa2 = c2.getDom();
            if (!DomImpl._node_getNodeName(aa2).equals(name)) continue;
            if (oldAttr == null) {
                oldAttr = aa2;
            }
            if (((AttrXobj)aa2).isId()) {
                Document d2 = DomImpl.node_getOwnerDocument(aa2);
                String val = DomImpl.node_getNodeValue(aa2);
                if (d2 instanceof DocumentXobj) {
                    ((DocumentXobj)d2).removeIdElement(val);
                }
            }
            DomImpl.removeNode(aa2);
            c2.toPrevAttr();
        }
        c2.release();
        if (oldAttr == null) {
            throw new NotFoundErr("Named item not found: " + name);
        }
        return (org.w3c.dom.Node)((Object)oldAttr);
    }

    public static org.w3c.dom.Node _attributes_removeNamedItemNS(Dom e2, String uri, String local) {
        return DomImpl.syncWrap(e2, p2 -> DomImpl.attributes_removeNamedItemNS(p2, uri, local));
    }

    public static org.w3c.dom.Node attributes_removeNamedItemNS(Dom e2, String uri, String local) {
        if (uri == null) {
            uri = "";
        }
        Dom oldAttr = null;
        Cur c2 = e2.tempCur();
        while (c2.toNextAttr()) {
            Dom aa2 = c2.getDom();
            QName qn = aa2.getQName();
            if (!qn.getNamespaceURI().equals(uri) || !qn.getLocalPart().equals(local)) continue;
            if (oldAttr == null) {
                oldAttr = aa2;
            }
            if (((AttrXobj)aa2).isId()) {
                Document d2 = DomImpl.node_getOwnerDocument(aa2);
                String val = DomImpl.node_getNodeValue(aa2);
                if (d2 instanceof DocumentXobj) {
                    ((DocumentXobj)d2).removeIdElement(val);
                }
            }
            DomImpl.removeNode(aa2);
            c2.toPrevAttr();
        }
        c2.release();
        if (oldAttr == null) {
            throw new NotFoundErr("Named item not found: uri=" + uri + ", local=" + local);
        }
        return (org.w3c.dom.Node)((Object)oldAttr);
    }

    public static org.w3c.dom.Node _attributes_setNamedItemNS(Dom e2, org.w3c.dom.Node attr) {
        Dom a2;
        Locale l2 = e2.locale();
        if (attr == null) {
            throw new IllegalArgumentException("Attr to set is null");
        }
        if (!(attr instanceof Dom) || (a2 = (Dom)((Object)attr)).locale() != l2) {
            throw new WrongDocumentErr("Attr to set is from another document");
        }
        return DomImpl.syncWrap(e2, p2 -> DomImpl.attributes_setNamedItemNS(p2, a2));
    }

    public static org.w3c.dom.Node attributes_setNamedItemNS(Dom e2, Dom a2) {
        Element owner = DomImpl.attr_getOwnerElement(a2);
        if (owner == e2) {
            return (org.w3c.dom.Node)((Object)a2);
        }
        if (owner != null) {
            throw new InuseAttributeError();
        }
        if (a2.nodeType() != 2) {
            throw new HierarchyRequestErr("Node is not an attribute");
        }
        QName name = a2.getQName();
        Dom oldAttr = null;
        Cur c2 = e2.tempCur();
        while (c2.toNextAttr()) {
            Dom aa2 = c2.getDom();
            if (!aa2.getQName().equals(name)) continue;
            if (oldAttr == null) {
                oldAttr = aa2;
                continue;
            }
            DomImpl.removeNode(aa2);
            c2.toPrevAttr();
        }
        if (oldAttr == null) {
            c2.moveToDom(e2);
            c2.next();
            Cur.moveNode((Xobj)((Object)a2), c2);
        } else {
            c2.moveToDom(oldAttr);
            Cur.moveNode((Xobj)((Object)a2), c2);
            DomImpl.removeNode(oldAttr);
        }
        c2.release();
        return (org.w3c.dom.Node)((Object)oldAttr);
    }

    public static org.w3c.dom.Node _attributes_item(Dom e2, int index) {
        return DomImpl.syncWrap(e2, p2 -> DomImpl.attributes_item(p2, index));
    }

    public static org.w3c.dom.Node attributes_item(Dom e2, int index) {
        if (index < 0) {
            return null;
        }
        Cur c2 = e2.tempCur();
        Dom a2 = null;
        while (c2.toNextAttr()) {
            if (index-- != 0) continue;
            a2 = c2.getDom();
            break;
        }
        c2.release();
        return (org.w3c.dom.Node)((Object)a2);
    }

    public static String _processingInstruction_getData(Dom p2) {
        return DomImpl._node_getNodeValue(p2);
    }

    public static String _processingInstruction_getTarget(Dom p2) {
        return DomImpl._node_getNodeName(p2);
    }

    public static void _processingInstruction_setData(Dom p2, String data) {
        DomImpl._node_setNodeValue(p2, data);
    }

    public static boolean _attr_getSpecified(Dom a2) {
        return true;
    }

    public static Element _attr_getOwnerElement(Dom a2) {
        return DomImpl.syncWrap(a2, DomImpl::attr_getOwnerElement);
    }

    public static Element attr_getOwnerElement(Dom n2) {
        Cur c2 = n2.tempCur();
        if (!c2.toParentRaw()) {
            c2.release();
            return null;
        }
        Dom p2 = c2.getDom();
        c2.release();
        return (Element)((Object)p2);
    }

    public static void _characterData_appendData(Dom cd2, String arg) {
        if (arg != null && arg.length() != 0) {
            DomImpl._node_setNodeValue(cd2, DomImpl._node_getNodeValue(cd2) + arg);
        }
    }

    public static void _characterData_deleteData(Dom c2, int offset, int count) {
        String s2 = DomImpl._characterData_getData(c2);
        if (offset < 0 || offset > s2.length() || count < 0) {
            throw new IndexSizeError();
        }
        if (offset + count > s2.length()) {
            count = s2.length() - offset;
        }
        if (count > 0) {
            DomImpl._characterData_setData(c2, s2.substring(0, offset) + s2.substring(offset + count));
        }
    }

    public static String _characterData_getData(Dom c2) {
        return DomImpl._node_getNodeValue(c2);
    }

    public static int _characterData_getLength(Dom c2) {
        return DomImpl._characterData_getData(c2).length();
    }

    public static void _characterData_insertData(Dom c2, int offset, String arg) {
        String s2 = DomImpl._characterData_getData(c2);
        if (offset < 0 || offset > s2.length()) {
            throw new IndexSizeError();
        }
        if (arg != null && arg.length() > 0) {
            DomImpl._characterData_setData(c2, s2.substring(0, offset) + arg + s2.substring(offset));
        }
    }

    public static void _characterData_replaceData(Dom c2, int offset, int count, String arg) {
        String s2 = DomImpl._characterData_getData(c2);
        if (offset < 0 || offset > s2.length() || count < 0) {
            throw new IndexSizeError();
        }
        if (offset + count > s2.length()) {
            count = s2.length() - offset;
        }
        if (count > 0) {
            DomImpl._characterData_setData(c2, s2.substring(0, offset) + (arg == null ? "" : arg) + s2.substring(offset + count));
        }
    }

    public static void _characterData_setData(Dom c2, String data) {
        DomImpl._node_setNodeValue(c2, data);
    }

    public static String _characterData_substringData(Dom c2, int offset, int count) {
        String s2 = DomImpl._characterData_getData(c2);
        if (offset < 0 || offset > s2.length() || count < 0) {
            throw new IndexSizeError();
        }
        if (offset + count > s2.length()) {
            count = s2.length() - offset;
        }
        return s2.substring(offset, offset + count);
    }

    public static Text _text_splitText(Dom t2, int offset) {
        assert (t2.nodeType() == 3);
        String s2 = DomImpl._characterData_getData(t2);
        if (offset < 0 || offset > s2.length()) {
            throw new IndexSizeError();
        }
        DomImpl._characterData_deleteData(t2, offset, s2.length() - offset);
        Dom t22 = (Dom)((Object)DomImpl._document_createTextNode(t2, s2.substring(offset)));
        Dom p2 = (Dom)((Object)DomImpl._node_getParentNode(t2));
        if (p2 != null) {
            DomImpl._node_insertBefore(p2, (Text)((Object)t22), DomImpl._node_getNextSibling(t2));
            t2.locale().invalidateDomCaches(p2);
        }
        return (Text)((Object)t22);
    }

    public static String _text_getWholeText(Dom t2) {
        throw new DomLevel3NotImplemented();
    }

    public static boolean _text_isElementContentWhitespace(Dom t2) {
        throw new DomLevel3NotImplemented();
    }

    public static Text _text_replaceWholeText(Dom t2, String content) {
        throw new DomLevel3NotImplemented();
    }

    public static XMLStreamReader _getXmlStreamReader(Dom n2) {
        return DomImpl.syncWrap(n2, DomImpl::getXmlStreamReader);
    }

    public static XMLStreamReader getXmlStreamReader(Dom n2) {
        XMLStreamReader xs;
        switch (n2.nodeType()) {
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                Cur c2 = n2.tempCur();
                xs = Jsr173.newXmlStreamReader(c2, null);
                c2.release();
                break;
            }
            case 3: 
            case 4: {
                CharNode cn = (CharNode)n2;
                Cur c3 = cn.tempCur();
                if (c3 == null) {
                    c3 = n2.locale().tempCur();
                    xs = Jsr173.newXmlStreamReader(c3, cn.getObject(), cn._off, cn._cch);
                } else {
                    xs = Jsr173.newXmlStreamReader(c3, c3.getChars(cn._cch), c3._offSrc, c3._cchSrc);
                }
                c3.release();
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 12: {
                throw new RuntimeException("Not impl");
            }
            default: {
                throw new RuntimeException("Unknown kind");
            }
        }
        return xs;
    }

    public static XmlCursor _getXmlCursor(Dom n2) {
        return DomImpl.syncWrap(n2, DomImpl::getXmlCursor);
    }

    public static XmlCursor getXmlCursor(Dom n2) {
        Cur c2 = n2.tempCur();
        Cursor xc = new Cursor(c2);
        c2.release();
        return xc;
    }

    public static XmlObject _getXmlObject(Dom n2) {
        return DomImpl.syncWrap(n2, DomImpl::getXmlObject);
    }

    public static XmlObject getXmlObject(Dom n2) {
        Cur c2 = n2.tempCur();
        XmlObject x2 = c2.getObject();
        c2.release();
        return x2;
    }

    public static boolean _soapText_isComment(Dom n2) {
        org.apache.xmlbeans.impl.soap.Text text = (org.apache.xmlbeans.impl.soap.Text)((Object)n2);
        return DomImpl.syncWrap(n2, p2 -> p2.locale()._saaj.soapText_isComment(text));
    }

    public static void _soapNode_detachNode(Dom n2) {
        Node node = (Node)((Object)n2);
        DomImpl.syncWrapVoid(n2, p2 -> p2.locale()._saaj.soapNode_detachNode(node));
    }

    public static void _soapNode_recycleNode(Dom n2) {
        Node node = (Node)((Object)n2);
        DomImpl.syncWrapVoid(n2, p2 -> p2.locale()._saaj.soapNode_recycleNode(node));
    }

    public static String _soapNode_getValue(Dom n2) {
        Node node = (Node)((Object)n2);
        return DomImpl.syncWrap(n2, p2 -> p2.locale()._saaj.soapNode_getValue(node));
    }

    public static void _soapNode_setValue(Dom n2, String value) {
        Node node = (Node)((Object)n2);
        DomImpl.syncWrapVoid(n2, p2 -> p2.locale()._saaj.soapNode_setValue(node, value));
    }

    public static SOAPElement _soapNode_getParentElement(Dom n2) {
        Node node = (Node)((Object)n2);
        return DomImpl.syncWrap(n2, p2 -> p2.locale()._saaj.soapNode_getParentElement(node));
    }

    public static void _soapNode_setParentElement(Dom n2, SOAPElement p2) {
        Node node = (Node)((Object)n2);
        DomImpl.syncWrapVoid(n2, x2 -> x2.locale()._saaj.soapNode_setParentElement(node, p2));
    }

    public static void _soapElement_removeContents(Dom d2) {
        SOAPElement se = (SOAPElement)((Object)d2);
        DomImpl.syncWrapVoid(d2, x2 -> x2.locale()._saaj.soapElement_removeContents(se));
    }

    public static String _soapElement_getEncodingStyle(Dom d2) {
        SOAPElement se = (SOAPElement)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapElement_getEncodingStyle(se));
    }

    public static void _soapElement_setEncodingStyle(Dom d2, String encodingStyle) {
        SOAPElement se = (SOAPElement)((Object)d2);
        DomImpl.syncWrapVoid(d2, p2 -> p2.locale()._saaj.soapElement_setEncodingStyle(se, encodingStyle));
    }

    public static boolean _soapElement_removeNamespaceDeclaration(Dom d2, String prefix) {
        SOAPElement se = (SOAPElement)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapElement_removeNamespaceDeclaration(se, prefix));
    }

    public static Iterator<Name> _soapElement_getAllAttributes(Dom d2) {
        SOAPElement se = (SOAPElement)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapElement_getAllAttributes(se));
    }

    public static Iterator<SOAPElement> _soapElement_getChildElements(Dom d2) {
        SOAPElement se = (SOAPElement)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapElement_getChildElements(se));
    }

    public static Iterator<String> _soapElement_getNamespacePrefixes(Dom d2) {
        SOAPElement se = (SOAPElement)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapElement_getNamespacePrefixes(se));
    }

    public static SOAPElement _soapElement_addAttribute(Dom d2, Name name, String value) throws SOAPException {
        SOAPElement se = (SOAPElement)((Object)d2);
        return DomImpl.syncWrapEx(d2, () -> d2.locale()._saaj.soapElement_addAttribute(se, name, value));
    }

    public static SOAPElement _soapElement_addChildElement(Dom d2, SOAPElement oldChild) throws SOAPException {
        SOAPElement se = (SOAPElement)((Object)d2);
        return DomImpl.syncWrapEx(d2, () -> d2.locale()._saaj.soapElement_addChildElement(se, oldChild));
    }

    public static SOAPElement _soapElement_addChildElement(Dom d2, Name name) throws SOAPException {
        SOAPElement se = (SOAPElement)((Object)d2);
        return DomImpl.syncWrapEx(d2, () -> d2.locale()._saaj.soapElement_addChildElement(se, name));
    }

    public static SOAPElement _soapElement_addChildElement(Dom d2, String localName) throws SOAPException {
        SOAPElement se = (SOAPElement)((Object)d2);
        return DomImpl.syncWrapEx(d2, () -> d2.locale()._saaj.soapElement_addChildElement(se, localName));
    }

    public static SOAPElement _soapElement_addChildElement(Dom d2, String localName, String prefix) throws SOAPException {
        SOAPElement se = (SOAPElement)((Object)d2);
        return DomImpl.syncWrapEx(d2, () -> d2.locale()._saaj.soapElement_addChildElement(se, localName, prefix));
    }

    public static SOAPElement _soapElement_addChildElement(Dom d2, String localName, String prefix, String uri) throws SOAPException {
        SOAPElement se = (SOAPElement)((Object)d2);
        return DomImpl.syncWrapEx(d2, () -> d2.locale()._saaj.soapElement_addChildElement(se, localName, prefix, uri));
    }

    public static SOAPElement _soapElement_addNamespaceDeclaration(Dom d2, String prefix, String uri) {
        SOAPElement se = (SOAPElement)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapElement_addNamespaceDeclaration(se, prefix, uri));
    }

    public static SOAPElement _soapElement_addTextNode(Dom d2, String data) {
        SOAPElement se = (SOAPElement)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapElement_addTextNode(se, data));
    }

    public static String _soapElement_getAttributeValue(Dom d2, Name name) {
        SOAPElement se = (SOAPElement)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapElement_getAttributeValue(se, name));
    }

    public static Iterator<SOAPElement> _soapElement_getChildElements(Dom d2, Name name) {
        SOAPElement se = (SOAPElement)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapElement_getChildElements(se, name));
    }

    public static Name _soapElement_getElementName(Dom d2) {
        SOAPElement se = (SOAPElement)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapElement_getElementName(se));
    }

    public static String _soapElement_getNamespaceURI(Dom d2, String prefix) {
        SOAPElement se = (SOAPElement)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapElement_getNamespaceURI(se, prefix));
    }

    public static Iterator<String> _soapElement_getVisibleNamespacePrefixes(Dom d2) {
        SOAPElement se = (SOAPElement)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapElement_getVisibleNamespacePrefixes(se));
    }

    public static boolean _soapElement_removeAttribute(Dom d2, Name name) {
        SOAPElement se = (SOAPElement)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapElement_removeAttribute(se, name));
    }

    public static SOAPBody _soapEnvelope_addBody(Dom d2) throws SOAPException {
        SOAPEnvelope se = (SOAPEnvelope)((Object)d2);
        return DomImpl.syncWrapEx(d2, () -> d2.locale()._saaj.soapEnvelope_addBody(se));
    }

    public static SOAPBody _soapEnvelope_getBody(Dom d2) throws SOAPException {
        SOAPEnvelope se = (SOAPEnvelope)((Object)d2);
        return DomImpl.syncWrapEx(d2, () -> d2.locale()._saaj.soapEnvelope_getBody(se));
    }

    public static SOAPHeader _soapEnvelope_getHeader(Dom d2) throws SOAPException {
        SOAPEnvelope se = (SOAPEnvelope)((Object)d2);
        return DomImpl.syncWrapEx(d2, () -> d2.locale()._saaj.soapEnvelope_getHeader(se));
    }

    public static SOAPHeader _soapEnvelope_addHeader(Dom d2) throws SOAPException {
        SOAPEnvelope se = (SOAPEnvelope)((Object)d2);
        return DomImpl.syncWrapEx(d2, () -> d2.locale()._saaj.soapEnvelope_addHeader(se));
    }

    public static Name _soapEnvelope_createName(Dom d2, String localName) {
        SOAPEnvelope se = (SOAPEnvelope)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapEnvelope_createName(se, localName));
    }

    public static Name _soapEnvelope_createName(Dom d2, String localName, String prefix, String namespaceURI) {
        SOAPEnvelope se = (SOAPEnvelope)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapEnvelope_createName(se, localName, prefix, namespaceURI));
    }

    public static Iterator<SOAPHeaderElement> soapHeader_examineAllHeaderElements(Dom d2) {
        SOAPHeader sh = (SOAPHeader)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapHeader_examineAllHeaderElements(sh));
    }

    public static Iterator<SOAPHeaderElement> soapHeader_extractAllHeaderElements(Dom d2) {
        SOAPHeader sh = (SOAPHeader)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapHeader_extractAllHeaderElements(sh));
    }

    public static Iterator<SOAPHeaderElement> soapHeader_examineHeaderElements(Dom d2, String actor) {
        SOAPHeader sh = (SOAPHeader)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapHeader_examineHeaderElements(sh, actor));
    }

    public static Iterator<SOAPHeaderElement> soapHeader_examineMustUnderstandHeaderElements(Dom d2, String mustUnderstandString) {
        SOAPHeader sh = (SOAPHeader)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapHeader_examineMustUnderstandHeaderElements(sh, mustUnderstandString));
    }

    public static Iterator<SOAPHeaderElement> soapHeader_extractHeaderElements(Dom d2, String actor) {
        SOAPHeader sh = (SOAPHeader)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapHeader_extractHeaderElements(sh, actor));
    }

    public static SOAPHeaderElement soapHeader_addHeaderElement(Dom d2, Name name) {
        SOAPHeader sh = (SOAPHeader)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapHeader_addHeaderElement(sh, name));
    }

    public static boolean soapBody_hasFault(Dom d2) {
        SOAPBody sb = (SOAPBody)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapBody_hasFault(sb));
    }

    public static SOAPFault soapBody_addFault(Dom d2) throws SOAPException {
        SOAPBody sb = (SOAPBody)((Object)d2);
        return DomImpl.syncWrapEx(d2, () -> d2.locale()._saaj.soapBody_addFault(sb));
    }

    public static SOAPFault soapBody_getFault(Dom d2) {
        SOAPBody sb = (SOAPBody)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapBody_getFault(sb));
    }

    public static SOAPBodyElement soapBody_addBodyElement(Dom d2, Name name) {
        SOAPBody sb = (SOAPBody)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapBody_addBodyElement(sb, name));
    }

    public static SOAPBodyElement soapBody_addDocument(Dom d2, Document document) {
        SOAPBody sb = (SOAPBody)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapBody_addDocument(sb, document));
    }

    public static SOAPFault soapBody_addFault(Dom d2, Name name, String s2) throws SOAPException {
        SOAPBody sb = (SOAPBody)((Object)d2);
        return DomImpl.syncWrapEx(d2, () -> d2.locale()._saaj.soapBody_addFault(sb, name, s2));
    }

    public static SOAPFault soapBody_addFault(Dom d2, Name faultCode, String faultString, java.util.Locale locale) throws SOAPException {
        SOAPBody sb = (SOAPBody)((Object)d2);
        return DomImpl.syncWrapEx(d2, () -> d2.locale()._saaj.soapBody_addFault(sb, faultCode, faultString, locale));
    }

    public static void soapFault_setFaultString(Dom d2, String faultString) {
        SOAPFault sf = (SOAPFault)((Object)d2);
        DomImpl.syncWrapVoid(d2, p2 -> p2.locale()._saaj.soapFault_setFaultString(sf, faultString));
    }

    public static void soapFault_setFaultString(Dom d2, String faultString, java.util.Locale locale) {
        SOAPFault sf = (SOAPFault)((Object)d2);
        DomImpl.syncWrapVoid(d2, p2 -> p2.locale()._saaj.soapFault_setFaultString(sf, faultString, locale));
    }

    public static void soapFault_setFaultCode(Dom d2, Name faultCodeName) throws SOAPException {
        SOAPFault sf = (SOAPFault)((Object)d2);
        DomImpl.syncWrapEx(d2, () -> {
            d2.locale()._saaj.soapFault_setFaultCode(sf, faultCodeName);
            return null;
        });
    }

    public static void soapFault_setFaultActor(Dom d2, String faultActorString) {
        SOAPFault sf = (SOAPFault)((Object)d2);
        DomImpl.syncWrapVoid(d2, p2 -> p2.locale()._saaj.soapFault_setFaultActor(sf, faultActorString));
    }

    public static String soapFault_getFaultActor(Dom d2) {
        SOAPFault sf = (SOAPFault)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapFault_getFaultActor(sf));
    }

    public static String soapFault_getFaultCode(Dom d2) {
        SOAPFault sf = (SOAPFault)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapFault_getFaultCode(sf));
    }

    public static void soapFault_setFaultCode(Dom d2, String faultCode) throws SOAPException {
        SOAPFault sf = (SOAPFault)((Object)d2);
        DomImpl.syncWrapEx(d2, () -> {
            d2.locale()._saaj.soapFault_setFaultCode(sf, faultCode);
            return null;
        });
    }

    public static java.util.Locale soapFault_getFaultStringLocale(Dom d2) {
        SOAPFault sf = (SOAPFault)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapFault_getFaultStringLocale(sf));
    }

    public static Name soapFault_getFaultCodeAsName(Dom d2) {
        SOAPFault sf = (SOAPFault)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapFault_getFaultCodeAsName(sf));
    }

    public static String soapFault_getFaultString(Dom d2) {
        SOAPFault sf = (SOAPFault)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapFault_getFaultString(sf));
    }

    public static Detail soapFault_addDetail(Dom d2) throws SOAPException {
        SOAPFault sf = (SOAPFault)((Object)d2);
        return DomImpl.syncWrapEx(d2, () -> d2.locale()._saaj.soapFault_addDetail(sf));
    }

    public static Detail soapFault_getDetail(Dom d2) {
        SOAPFault sf = (SOAPFault)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapFault_getDetail(sf));
    }

    public static void soapHeaderElement_setMustUnderstand(Dom d2, boolean mustUnderstand) {
        SOAPHeaderElement she = (SOAPHeaderElement)((Object)d2);
        DomImpl.syncWrapVoid(d2, p2 -> p2.locale()._saaj.soapHeaderElement_setMustUnderstand(she, mustUnderstand));
    }

    public static boolean soapHeaderElement_getMustUnderstand(Dom d2) {
        SOAPHeaderElement she = (SOAPHeaderElement)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapHeaderElement_getMustUnderstand(she));
    }

    public static void soapHeaderElement_setActor(Dom d2, String actor) {
        SOAPHeaderElement she = (SOAPHeaderElement)((Object)d2);
        DomImpl.syncWrapVoid(d2, p2 -> p2.locale()._saaj.soapHeaderElement_setActor(she, actor));
    }

    public static String soapHeaderElement_getActor(Dom d2) {
        SOAPHeaderElement she = (SOAPHeaderElement)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapHeaderElement_getActor(she));
    }

    public static DetailEntry detail_addDetailEntry(Dom d2, Name name) {
        Detail detail = (Detail)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.detail_addDetailEntry(detail, name));
    }

    public static Iterator<DetailEntry> detail_getDetailEntries(Dom d2) {
        Detail detail = (Detail)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.detail_getDetailEntries(detail));
    }

    public static void _soapPart_removeAllMimeHeaders(Dom d2) {
        SOAPPart sp = (SOAPPart)((Object)d2);
        DomImpl.syncWrapVoid(d2, p2 -> p2.locale()._saaj.soapPart_removeAllMimeHeaders(sp));
    }

    public static void _soapPart_removeMimeHeader(Dom d2, String name) {
        SOAPPart sp = (SOAPPart)((Object)d2);
        DomImpl.syncWrapVoid(d2, p2 -> p2.locale()._saaj.soapPart_removeMimeHeader(sp, name));
    }

    public static Iterator<MimeHeader> _soapPart_getAllMimeHeaders(Dom d2) {
        SOAPPart sp = (SOAPPart)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapPart_getAllMimeHeaders(sp));
    }

    public static SOAPEnvelope _soapPart_getEnvelope(Dom d2) {
        SOAPPart sp = (SOAPPart)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapPart_getEnvelope(sp));
    }

    public static Source _soapPart_getContent(Dom d2) {
        SOAPPart sp = (SOAPPart)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapPart_getContent(sp));
    }

    public static void _soapPart_setContent(Dom d2, Source source) {
        SOAPPart sp = (SOAPPart)((Object)d2);
        DomImpl.syncWrapVoid(d2, p2 -> p2.locale()._saaj.soapPart_setContent(sp, source));
    }

    public static String[] _soapPart_getMimeHeader(Dom d2, String name) {
        SOAPPart sp = (SOAPPart)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapPart_getMimeHeader(sp, name));
    }

    public static void _soapPart_addMimeHeader(Dom d2, String name, String value) {
        SOAPPart sp = (SOAPPart)((Object)d2);
        DomImpl.syncWrapVoid(d2, p2 -> p2.locale()._saaj.soapPart_addMimeHeader(sp, name, value));
    }

    public static void _soapPart_setMimeHeader(Dom d2, String name, String value) {
        SOAPPart sp = (SOAPPart)((Object)d2);
        DomImpl.syncWrapVoid(d2, p2 -> p2.locale()._saaj.soapPart_setMimeHeader(sp, name, value));
    }

    public static Iterator<MimeHeader> _soapPart_getMatchingMimeHeaders(Dom d2, String[] names) {
        SOAPPart sp = (SOAPPart)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapPart_getMatchingMimeHeaders(sp, names));
    }

    public static Iterator<MimeHeader> _soapPart_getNonMatchingMimeHeaders(Dom d2, String[] names) {
        SOAPPart sp = (SOAPPart)((Object)d2);
        return DomImpl.syncWrap(d2, p2 -> p2.locale()._saaj.soapPart_getNonMatchingMimeHeaders(sp, names));
    }

    public static void saajCallback_setSaajData(Dom d2, Object o2) {
        DomImpl.syncWrapVoid(d2, p2 -> DomImpl.impl_saajCallback_setSaajData(p2, o2));
    }

    public static void impl_saajCallback_setSaajData(Dom d2, Object o2) {
        Locale l2 = d2.locale();
        Cur c2 = l2.tempCur();
        c2.moveToDom(d2);
        SaajData sd = null;
        if (o2 != null) {
            sd = (SaajData)c2.getBookmark(SaajData.class);
            if (sd == null) {
                sd = new SaajData();
            }
            sd._obj = o2;
        }
        c2.setBookmark(SaajData.class, sd);
        c2.release();
    }

    public static Object saajCallback_getSaajData(Dom d2) {
        return DomImpl.syncWrap(d2, DomImpl::impl_saajCallback_getSaajData);
    }

    public static Object impl_saajCallback_getSaajData(Dom d2) {
        Locale l2 = d2.locale();
        Cur c2 = l2.tempCur();
        c2.moveToDom(d2);
        SaajData sd = (SaajData)c2.getBookmark(SaajData.class);
        Object o2 = sd == null ? null : sd._obj;
        c2.release();
        return o2;
    }

    public static Element saajCallback_createSoapElement(Dom d2, QName name, QName parentName) {
        return DomImpl.syncWrap(d2, p2 -> DomImpl.impl_saajCallback_createSoapElement(p2, name, parentName));
    }

    public static Element impl_saajCallback_createSoapElement(Dom d2, QName name, QName parentName) {
        Cur c2 = d2.locale().tempCur();
        c2.createElement(name, parentName);
        Dom e2 = c2.getDom();
        c2.release();
        return (Element)((Object)e2);
    }

    public static Element saajCallback_importSoapElement(Dom d2, Element elem, boolean deep, QName parentName) {
        return DomImpl.syncWrap(d2, p2 -> DomImpl.impl_saajCallback_importSoapElement(p2, elem, deep, parentName));
    }

    public static Element impl_saajCallback_importSoapElement(Dom d2, Element elem, boolean deep, QName parentName) {
        throw new RuntimeException("Not impl");
    }

    public static Text saajCallback_ensureSoapTextNode(Dom d2) {
        return DomImpl.syncWrap(d2, DomImpl::impl_saajCallback_ensureSoapTextNode);
    }

    public static Text impl_saajCallback_ensureSoapTextNode(Dom d2) {
        return null;
    }

    private static <T> T syncWrap(Dom d2, Function<Dom, T> inner) {
        return (T)DomImpl.syncWrapHelper(d2.locale(), true, () -> inner.apply(d2));
    }

    private static <T> T syncWrapNoEnter(Dom d2, Function<Dom, T> inner) {
        return (T)DomImpl.syncWrapHelper(d2.locale(), false, () -> inner.apply(d2));
    }

    private static void syncWrapVoid(Dom d2, Consumer<Dom> inner) {
        DomImpl.syncWrapHelper(d2.locale(), true, () -> {
            inner.accept(d2);
            return null;
        });
    }

    private static <T> T syncWrapEx(Dom d2, WrapSoapEx<T> inner) throws SOAPException {
        return DomImpl.syncWrapHelperEx(d2.locale(), true, inner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T syncWrapHelper(Locale l2, boolean enter, Supplier<T> inner) {
        if (l2.noSync()) {
            return DomImpl.syncWrapHelper2(l2, enter, inner);
        }
        Locale locale = l2;
        synchronized (locale) {
            return DomImpl.syncWrapHelper2(l2, enter, inner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T syncWrapHelper2(Locale l2, boolean enter, Supplier<T> inner) {
        if (enter) {
            l2.enter();
        }
        try {
            T t2 = inner.get();
            return t2;
        }
        finally {
            if (enter) {
                l2.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T syncWrapHelperEx(Locale l2, boolean enter, WrapSoapEx<T> inner) throws SOAPException {
        if (l2.noSync()) {
            return DomImpl.syncWrapHelperEx2(l2, enter, inner);
        }
        Locale locale = l2;
        synchronized (locale) {
            return DomImpl.syncWrapHelperEx2(l2, enter, inner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T syncWrapHelperEx2(Locale l2, boolean enter, WrapSoapEx<T> inner) throws SOAPException {
        if (enter) {
            l2.enter();
        }
        try {
            T t2 = inner.get();
            return t2;
        }
        finally {
            if (enter) {
                l2.exit();
            }
        }
    }

    private static interface WrapSoapEx<T> {
        public T get() throws SOAPException;
    }

    public static class DomLevel3NotImplemented
    extends RuntimeException {
        DomLevel3NotImplemented() {
            super("DOM Level 3 Not implemented");
        }
    }

    private static class SaajData {
        Object _obj;

        private SaajData() {
        }
    }

    private static class ElementsByTagNameNSNodeList
    extends ElementsNodeList {
        private final String _uri;
        private final String _local;

        ElementsByTagNameNSNodeList(Dom root, String uri, String local) {
            super(root);
            this._uri = uri == null ? "" : uri;
            this._local = local;
            assert (local != null);
        }

        @Override
        protected boolean match(Dom element) {
            if (!this._uri.equals("*") && !this._uri.equals(DomImpl._node_getNamespaceURI(element))) {
                return false;
            }
            return this._local.equals("*") || this._local.equals(DomImpl._node_getLocalName(element));
        }
    }

    private static class ElementsByTagNameNodeList
    extends ElementsNodeList {
        private final String _name;

        ElementsByTagNameNodeList(Dom root, String name) {
            super(root);
            this._name = name;
            assert (this._name != null);
        }

        @Override
        protected boolean match(Dom element) {
            return this._name.equals("*") || this._name.equals(DomImpl._node_getNodeName(element));
        }
    }

    private static abstract class ElementsNodeList
    implements NodeList {
        private final Dom _root;
        private final Locale _locale;
        private long _version;
        private ArrayList<Dom> _elements;

        ElementsNodeList(Dom root) {
            assert (root.nodeType() == 9 || root.nodeType() == 1);
            this._root = root;
            this._locale = this._root.locale();
            this._version = 0L;
        }

        @Override
        public int getLength() {
            this.ensureElements();
            return this._elements.size();
        }

        @Override
        public org.w3c.dom.Node item(int i2) {
            this.ensureElements();
            return i2 < 0 || i2 >= this._elements.size() ? null : (org.w3c.dom.Node)((Object)this._elements.get(i2));
        }

        private void ensureElements() {
            if (this._version == this._locale.version()) {
                return;
            }
            this._version = this._locale.version();
            this._elements = new ArrayList();
            DomImpl.syncWrapHelper(this._locale, true, () -> {
                this.addElements(this._root);
                return null;
            });
        }

        private void addElements(Dom node) {
            org.w3c.dom.Node c2 = DomImpl.firstChild(node);
            while (c2 != null) {
                if (((Dom)((Object)c2)).nodeType() == 1) {
                    if (this.match((Dom)((Object)c2))) {
                        this._elements.add((Dom)((Object)c2));
                    }
                    this.addElements((Dom)((Object)c2));
                }
                c2 = DomImpl.nextSibling((Dom)((Object)c2));
            }
        }

        protected abstract boolean match(Dom var1);
    }

    private static final class EmptyNodeList
    implements NodeList {
        private EmptyNodeList() {
        }

        @Override
        public int getLength() {
            return 0;
        }

        @Override
        public org.w3c.dom.Node item(int i2) {
            return null;
        }
    }

    static class InvalidCharacterError
    extends DOMException {
        InvalidCharacterError() {
            this("The name contains an invalid character");
        }

        InvalidCharacterError(String message) {
            super((short)5, message);
        }
    }

    static class NotSupportedError
    extends DOMException {
        NotSupportedError(String message) {
            super((short)9, message);
        }
    }

    static class IndexSizeError
    extends DOMException {
        IndexSizeError() {
            this("Index Size Error");
        }

        IndexSizeError(String message) {
            super((short)1, message);
        }
    }

    static class InuseAttributeError
    extends DOMException {
        InuseAttributeError() {
            this("Attribute currently in use error");
        }

        InuseAttributeError(String message) {
            super((short)10, message);
        }
    }

    static class NoModificationAllowedErr
    extends DOMException {
        NoModificationAllowedErr(String message) {
            super((short)7, message);
        }
    }

    static class NamespaceErr
    extends DOMException {
        NamespaceErr(String message) {
            super((short)14, message);
        }
    }

    static class NotFoundErr
    extends DOMException {
        NotFoundErr(String message) {
            super((short)8, message);
        }
    }

    static class WrongDocumentErr
    extends DOMException {
        WrongDocumentErr(String message) {
            super((short)4, message);
        }
    }

    static class HierarchyRequestErr
    extends DOMException {
        HierarchyRequestErr(String message) {
            super((short)3, message);
        }
    }

    public static interface Dom {
        public Locale locale();

        public int nodeType();

        public Cur tempCur();

        public QName getQName();

        public boolean nodeCanHavePrefixUri();

        public void dump();

        public void dump(PrintStream var1);

        public void dump(PrintStream var1, Object var2);
    }
}

