/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.xpath.saxon;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DOMNodeWrapper;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.sxpath.XPathStaticContext;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.tree.wrapper.VirtualNode;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.GDateValue;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.store.Cur;
import org.apache.xmlbeans.impl.xpath.Path;
import org.apache.xmlbeans.impl.xpath.XPathEngine;
import org.apache.xmlbeans.impl.xpath.saxon.SaxonXPathEngine;
import org.w3c.dom.Node;

public class SaxonXPath
implements Path {
    private final Map<String, String> namespaceMap = new HashMap<String, String>();
    private String path;
    private String contextVar;
    private String defaultNS;

    public SaxonXPath(String path, String contextVar, Map<String, String> namespaceMap) {
        this.path = path;
        this.contextVar = contextVar;
        this.defaultNS = namespaceMap.get("$xmlbeans!default_uri");
        this.namespaceMap.putAll(namespaceMap);
        this.namespaceMap.remove("$xmlbeans!default_uri");
    }

    @Override
    public XPathEngine execute(Cur c2, XmlOptions options) {
        return new SaxonXPathEngine(this, c2);
    }

    public List selectNodes(Object node) {
        try {
            Node contextNode = (Node)node;
            Configuration config = new Configuration();
            IndependentContext sc = new IndependentContext(config);
            if (this.defaultNS != null) {
                sc.setDefaultElementNamespace(NamespaceUri.of((String)this.defaultNS));
            }
            for (Map.Entry<String, String> entry : this.namespaceMap.entrySet()) {
                sc.declareNamespace(entry.getKey(), NamespaceUri.of((String)entry.getValue()));
            }
            NodeInfo contextItem = config.unravel((Source)new DOMSource(contextNode));
            XPathEvaluator xpe = new XPathEvaluator(config);
            xpe.setStaticContext((XPathStaticContext)sc);
            XPathVariable thisVar = sc.declareVariable(NamespaceUri.of((String)""), this.contextVar);
            XPathExpression xpath = xpe.createExpression(this.path);
            XPathDynamicContext dc = xpath.createDynamicContext(null);
            dc.setContextItem((Item)contextItem);
            dc.setVariable(thisVar, (Sequence)contextItem);
            List saxonNodes = xpath.evaluate(dc);
            ArrayList<Object> retNodes = new ArrayList<Object>(saxonNodes.size());
            for (Item o2 : saxonNodes) {
                if (o2 instanceof DOMNodeWrapper) {
                    Node n2 = SaxonXPath.getUnderlyingNode((VirtualNode)((DOMNodeWrapper)o2));
                    retNodes.add(n2);
                    continue;
                }
                if (o2 instanceof NodeInfo) {
                    retNodes.add(o2.getStringValue());
                    continue;
                }
                if (o2 instanceof GDateValue) {
                    retNodes.add(o2);
                    continue;
                }
                if (o2 instanceof DateTimeValue) {
                    retNodes.add(o2);
                    continue;
                }
                retNodes.add(SequenceTool.convertToJava((Item)o2));
            }
            return retNodes;
        }
        catch (TransformerException e2) {
            throw new RuntimeException(e2);
        }
    }

    public List selectPath(Object node) {
        return this.selectNodes(node);
    }

    private static Node getUnderlyingNode(VirtualNode v2) {
        Object o2 = v2;
        while (o2 instanceof VirtualNode) {
            o2 = o2.getUnderlyingNode();
        }
        return (Node)o2;
    }
}

