/*
 * Decompiled with CFR 0.152.
 */
package top.tanmw.db2dict;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.tanmw.db2dict.db.DbConfig;
import top.tanmw.db2dict.db.DbConfigFactory;
import top.tanmw.db2dict.entity.DbConstant;
import top.tanmw.db2dict.entity.DbEnum;
import top.tanmw.db2dict.entity.TableInfo;
import top.tanmw.db2dict.word.WordConfig;
import top.tanmw.db2dict.word.WordUtil;

public class Db2dictApplication {
    private static final Logger log = LoggerFactory.getLogger(Db2dictApplication.class);

    public static void main(String[] args) throws Exception {
        Properties prop = Db2dictApplication.getProp();
        if (Objects.isNull(prop)) {
            return;
        }
        DbConfig dbConfig = DbConfigFactory.getDbConfig();
        dbConfig.init(prop);
        List<TableInfo> tableList = dbConfig.getTableList();
        WordUtil wordUtil = new WordUtil();
        wordUtil.writeTableToWord(tableList);
    }

    public static void run(String url) throws Exception {
        Properties prop = Db2dictApplication.getProperties(url);
        Db2dictApplication.initProp(prop);
        DbConfig dbConfig = DbConfigFactory.getDbConfig();
        dbConfig.init(prop);
        List<TableInfo> tableList = dbConfig.getTableList();
        WordUtil wordUtil = new WordUtil();
        wordUtil.writeTableToWord(tableList);
    }

    public static void run() throws Exception {
        String path = Db2dictApplication.class.getClassLoader().getResource("dbconfig.txt").getPath();
        Db2dictApplication.run(path);
    }

    public static Properties getProperties(String url) throws Exception {
        Properties properties = new Properties();
        File file = new File(url);
        InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);
        properties.load(new InputStreamReader(in, StandardCharsets.UTF_8));
        return properties;
    }

    public static Properties getProp() {
        Properties properties = new Properties();
        try {
            log.info("...\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6...");
            String configPath = Db2dictApplication.class.getClassLoader().getResource("dbconfig.txt").getPath();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(configPath));
            properties.load(bufferedReader);
            Db2dictApplication.initProp(properties);
            return properties;
        }
        catch (Exception e2) {
            log.error("\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", e2);
            return null;
        }
    }

    public static void initProp(Properties properties) {
        DbConfigFactory.dbEnum = DbEnum.getDbEnum(properties.getProperty(DbConstant.TYPE));
        WordConfig.EXPORT_FILE_PATH = properties.getProperty(DbConstant.EXPORT_PATH);
    }
}

