/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.auth.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.efficient.auth.api.AuthService;
import com.efficient.auth.api.LoginService;
import com.efficient.auth.constant.AuthResultEnum;
import com.efficient.auth.constant.LoginTypeEnum;
import com.efficient.auth.model.dto.LoginInfo;
import com.efficient.auth.model.entity.UserAuthInfo;
import com.efficient.auth.properties.AuthProperties;
import com.efficient.auth.properties.LoginProperties;
import com.efficient.auth.util.AuthUtil;
import com.efficient.auth.util.JwtUtil;
import com.efficient.auth.util.TokenUtil;
import com.efficient.cache.api.CacheUtil;
import com.efficient.common.auth.RequestHolder;
import com.efficient.common.auth.UserTicket;
import com.efficient.common.result.Result;
import com.efficient.common.result.ResultConstant;
import com.efficient.common.util.AESUtils;
import com.efficient.common.util.JackSonUtil;
import com.efficient.ykz.api.YkzApiService;
import com.efficient.ykz.model.vo.YkzLoginUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoginServiceImpl
implements LoginService {
    @Autowired
    private AuthService authService;
    @Autowired
    private YkzApiService ykzApiService;
    @Autowired
    private AuthProperties authProperties;
    @Autowired
    private AuthUtil authUtil;
    @Autowired
    private CacheUtil cacheUtil;
    @Autowired
    private JwtUtil jwtUtil;

    @Override
    public Result<UserTicket> login(LoginInfo info) {
        Result<UserTicket> result;
        UserAuthInfo userAuthInfo = this.getUserAuthByLogin(info);
        if (Objects.isNull(userAuthInfo)) {
            return Result.build((ResultConstant)AuthResultEnum.ACCOUNT_FAIL);
        }
        LoginProperties loginProperties = this.authProperties.getLogin();
        Date unLockTime = userAuthInfo.getUnLockTime();
        String userId = userAuthInfo.getUserId();
        if (Objects.nonNull(unLockTime)) {
            long between = DateUtil.between((Date)unLockTime, (Date)new Date(), (DateUnit)DateUnit.MINUTE);
            if (between <= 0L) {
                this.authService.unLockUser(userId);
            } else {
                return Result.build((ResultConstant)AuthResultEnum.ACCOUNT_LOCK);
            }
        }
        if (Objects.equals(info.getLoginType(), LoginTypeEnum.LOGIN.getCode())) {
            if (!this.authUtil.checkEncrypt(userAuthInfo.getPassword(), info.getPassword())) {
                int retryCount = loginProperties.getRetryCount();
                int retryTime = loginProperties.getRetryTime();
                int lockTime = loginProperties.getLockTime();
                if (retryCount == -1) {
                    return Result.build((ResultConstant)AuthResultEnum.ACCOUNT_FAIL);
                }
                int count = (Integer)this.cacheUtil.get("auth-cache", "login-fail:" + userId);
                if (++count > retryCount) {
                    return Result.build((ResultConstant)AuthResultEnum.ACCOUNT_LOCK);
                }
                if (count < retryCount) {
                    this.cacheUtil.put("auth-cache", "login-fail:" + userId, (Object)count, retryTime * 60);
                    return Result.build((Integer)AuthResultEnum.ACCOUNT_LOCK_COUNT.getCode(), (String)String.format(AuthResultEnum.ACCOUNT_LOCK_COUNT.getMsg(), retryCount - count));
                }
                unLockTime = DateUtil.offset((Date)new Date(), (DateField)DateField.MINUTE, (int)lockTime);
                this.cacheUtil.removeCache("auth-cache", "login-fail:" + userId);
                this.authService.lockUser(userId, unLockTime);
                return Result.build((ResultConstant)AuthResultEnum.ACCOUNT_LOCK);
            }
            this.cacheUtil.removeCache("auth-cache", "login-fail:" + userId);
            this.authService.lockUser(userId, unLockTime);
        }
        int maxOnline = loginProperties.getMaxOnline();
        List<String> userTokenList = new ArrayList();
        if (maxOnline > 0) {
            userTokenList = (List)this.cacheUtil.get("auth-cache", "on-line-user:" + userId);
            if (CollUtil.isNotEmpty(userTokenList)) {
                if (maxOnline <= userTokenList.size()) {
                    return Result.build((ResultConstant)AuthResultEnum.USER_MAX_ONLINE);
                }
            } else {
                userTokenList = new ArrayList();
            }
        }
        if (!Objects.equals((result = this.authService.getUserTicket(userAuthInfo)).getCode(), Result.ok().getCode())) {
            return result;
        }
        UserTicket userTicket = (UserTicket)result.getData();
        userTicket.setUserId(userId);
        userTicket.setLoginType(info.getLoginType());
        userTicket.setAccount(userAuthInfo.getAccount());
        userTicket.setUsername(userAuthInfo.getUsername());
        userTicket.setLoginIp(info.getLoginIp());
        userTicket.setZwddId(userAuthInfo.getZwddId());
        long timeMillis = System.currentTimeMillis();
        String token = TokenUtil.createToken(userTicket.getUserId(), timeMillis, RequestHolder.getCurrRequest());
        userTicket.setToken(token);
        String jwtToken = this.jwtUtil.createToken(userTicket);
        userTicket.setCreateTime(timeMillis);
        RequestHolder.set((UserTicket)userTicket);
        int tokenLive = this.authProperties.getLogin().getTokenLive();
        this.cacheUtil.put("auth-cache", "token:" + token, (Object)jwtToken, tokenLive);
        userTokenList.add(token);
        this.cacheUtil.put("auth-cache", "on-line-user:" + userId, userTokenList, tokenLive);
        return Result.ok((Object)userTicket);
    }

    @Override
    public void putCacheUser(String token, UserTicket userTicket) {
        int tokenLive = this.authProperties.getLogin().getTokenLive();
        String jwtToken = this.jwtUtil.createToken(userTicket);
        this.cacheUtil.put("auth-cache", "token:" + token, (Object)jwtToken, tokenLive);
    }

    @Override
    public UserTicket getCacheUser(String token) {
        String jwtToken = (String)this.cacheUtil.get("auth-cache", "token:" + token);
        return this.jwtUtil.validateToken(jwtToken, this.authProperties.getUserTicketClass());
    }

    @Override
    public boolean checkUserTokens(String userId) {
        int tokenLive = this.authProperties.getLogin().getTokenLive();
        List userTokenList = (List)this.cacheUtil.get("auth-cache", "on-line-user:" + userId);
        if (CollUtil.isNotEmpty((Collection)userTokenList)) {
            Iterator iterator = userTokenList.iterator();
            while (iterator.hasNext()) {
                String token = (String)iterator.next();
                String tokenCacheKey = "token:" + token;
                if (!Objects.isNull(this.cacheUtil.get("auth-cache", tokenCacheKey))) continue;
                iterator.remove();
                this.cacheUtil.removeCache("auth-cache", tokenCacheKey);
            }
            this.cacheUtil.put("auth-cache", "on-line-user:" + userId, (Object)userTokenList, tokenLive);
        }
        return true;
    }

    @Override
    public UserAuthInfo getUserAuthByLogin(LoginInfo info) {
        Integer loginType = info.getLoginType();
        if (Objects.equals(loginType, LoginTypeEnum.LOGIN.getCode())) {
            return this.authService.getUserByAccount(info);
        }
        if (Objects.equals(loginType, LoginTypeEnum.YKZ_LOGIN.getCode())) {
            String authCode = info.getAuthCode();
            Result result = this.ykzApiService.getUserInfo(authCode);
            if (!Objects.equals(result.getCode(), Result.ok().getCode())) {
                return null;
            }
            Long accountId = ((YkzLoginUser)result.getData()).getAccountId();
            return this.authService.getUserByZwddId(String.valueOf(accountId));
        }
        if (Objects.equals(loginType, LoginTypeEnum.YKZ_TODO_LOGIN.getCode())) {
            String authCode = info.getAuthCode();
            UserTicket userTicket = (UserTicket)JackSonUtil.toObject((String)AESUtils.decrypt((String)authCode), UserTicket.class);
            if (Objects.isNull(userTicket)) {
                return null;
            }
            UserAuthInfo userByAccount = this.authService.getUserByZwddId(userTicket.getZwddId());
            if (!StrUtil.equals((CharSequence)userTicket.getZwddId(), (CharSequence)userByAccount.getZwddId())) {
                return null;
            }
            return userByAccount;
        }
        String authCode = info.getAuthCode();
        return this.authService.getUserByOtherAuthCode(authCode);
    }

    @Override
    public void logout(String token, String userId) {
        this.cacheUtil.removeCache("auth-cache", "token:" + token);
        this.cacheUtil.removeCache("auth-cache", "login-fail:" + userId);
        List userTokenList = (List)this.cacheUtil.get("auth-cache", "on-line-user:" + userId);
        if (CollUtil.isNotEmpty((Collection)userTokenList) && !userTokenList.isEmpty()) {
            userTokenList.remove(token);
            int tokenLive = this.authProperties.getLogin().getTokenLive();
            this.cacheUtil.put("auth-cache", "on-line-user:" + userId, (Object)userTokenList, tokenLive);
        } else {
            this.cacheUtil.removeCache("auth-cache", "on-line-user:" + userId);
        }
    }

    @Override
    public boolean checkCaptcha(String captchaId, String captcha) {
        String captchaCache = (String)this.cacheUtil.get("auth-cache", "captcha:" + captchaId);
        return !StrUtil.isBlank((CharSequence)captchaCache) && StrUtil.equalsIgnoreCase((CharSequence)captcha, (CharSequence)captchaCache);
    }
}

