/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.auth.interceptor;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.efficient.auth.constant.AuthResultEnum;
import com.efficient.auth.permission.Permission;
import com.efficient.auth.properties.AuthProperties;
import com.efficient.cache.api.CacheUtil;
import com.efficient.common.auth.RequestHolder;
import com.efficient.common.auth.UserTicket;
import com.efficient.common.constant.MenuRelation;
import com.efficient.common.result.Result;
import com.efficient.common.result.ResultConstant;
import com.efficient.common.result.ResultEnum;
import com.efficient.common.util.JackSonUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class PermissionInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(PermissionInterceptor.class);
    @Autowired
    private CacheUtil cacheUtil;
    @Autowired
    private AuthProperties authProperties;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        HandlerMethod method;
        try {
            method = (HandlerMethod)handler;
        }
        catch (ClassCastException e) {
            this.returnJson(response, AuthResultEnum.REQUEST_PATH_ERROR);
            return false;
        }
        Permission permission = (Permission)method.getMethodAnnotation(Permission.class);
        if (Objects.isNull(permission)) {
            permission = method.getBeanType().getAnnotation(Permission.class);
        }
        if (Objects.isNull(permission)) {
            return true;
        }
        String token = request.getHeader("token");
        if (StrUtil.isBlank((CharSequence)token)) {
            this.returnJson(response, AuthResultEnum.NOT_LOGIN);
            return false;
        }
        UserTicket userTicket = (UserTicket)this.cacheUtil.get("auth-cache", "auth-token-cache:" + token);
        if (userTicket == null) {
            this.returnJson(response, AuthResultEnum.NOT_LOGIN);
            return false;
        }
        this.cacheUtil.refresh("auth-cache", "auth-token-cache:" + token, this.authProperties.getTokenLive());
        this.cacheUtil.refresh("auth-cache", "auth-user-cache:" + userTicket.getUserId(), this.authProperties.getTokenLive());
        boolean checkPermission = this.checkPermission(permission, userTicket.getPermissionList());
        if (!checkPermission) {
            this.returnJson(response, (ResultConstant)ResultEnum.NOT_PERMISSION);
            return false;
        }
        RequestHolder.set((UserTicket)userTicket);
        return true;
    }

    private boolean checkPermission(Permission permission, List<String> currMenus) {
        String[] menuEnums = permission.value();
        if (menuEnums.length <= 0) {
            return true;
        }
        if (CollUtil.isEmpty(currMenus)) {
            return false;
        }
        MenuRelation relation = permission.relation();
        if (Objects.equals(relation, MenuRelation.OR)) {
            return Arrays.stream(menuEnums).anyMatch(currMenus::contains);
        }
        return Arrays.stream(menuEnums).allMatch(currMenus::contains);
    }

    private void returnJson(HttpServletResponse response, ResultConstant resultEnum) throws IOException {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        PrintWriter out = response.getWriter();
        out.append(JackSonUtil.toJson((Object)Result.build((ResultConstant)resultEnum)));
        out.close();
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        RequestHolder.remove();
        super.afterCompletion(request, response, handler, ex);
    }
}

