/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.auth.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.efficient.auth.api.AuthService;
import com.efficient.auth.api.LoginService;
import com.efficient.auth.constant.AuthResultEnum;
import com.efficient.auth.model.dto.LoginInfo;
import com.efficient.auth.model.entity.UserCheck;
import com.efficient.auth.properties.AuthProperties;
import com.efficient.auth.util.AuthUtil;
import com.efficient.auth.util.TokenUtil;
import com.efficient.cache.api.CacheUtil;
import com.efficient.common.auth.UserTicket;
import com.efficient.common.result.Result;
import com.efficient.common.result.ResultConstant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoginServiceImpl
implements LoginService {
    @Autowired
    private AuthService authService;
    @Autowired
    private AuthProperties authProperties;
    @Autowired
    private AuthUtil authUtil;
    @Autowired
    private CacheUtil cacheUtil;

    @Override
    public Result login(LoginInfo info) {
        UserCheck userCheck = this.authService.getUserInfo(info);
        if (Objects.isNull(userCheck)) {
            return Result.build((ResultConstant)AuthResultEnum.USER_NOT_EXIST);
        }
        Date unLockTime = userCheck.getUnLockTime();
        String userId = userCheck.getUserId();
        if (Objects.nonNull(unLockTime)) {
            long between = DateUtil.between((Date)unLockTime, (Date)new Date(), (DateUnit)DateUnit.MINUTE);
            if (between <= 0L) {
                this.authService.unLockUser(userId);
            } else {
                return Result.build((ResultConstant)AuthResultEnum.ACCOUNT_LOCK);
            }
        }
        if (!StrUtil.equals((CharSequence)userCheck.getPassword(), (CharSequence)this.authUtil.encrypt(info.getPassword()))) {
            int retryCount = this.authProperties.getRetryCount();
            int lockTime = this.authProperties.getLockTime();
            int count = (Integer)this.cacheUtil.get("auth-cache", "auth-fail-cache:" + userId);
            if (++count > retryCount) {
                return Result.build((ResultConstant)AuthResultEnum.ACCOUNT_LOCK);
            }
            if (count < retryCount) {
                this.cacheUtil.put("auth-cache", "auth-fail-cache:" + userId, (Object)count);
                return Result.build((Integer)AuthResultEnum.ACCOUNT_LOCK_COUNT.getCode(), (String)String.format(AuthResultEnum.ACCOUNT_LOCK_COUNT.getMsg(), retryCount - count));
            }
            unLockTime = DateUtil.offset((Date)new Date(), (DateField)DateField.MINUTE, (int)lockTime);
            this.cacheUtil.removeCache("auth-cache", "auth-fail-cache:" + userId);
            this.authService.lockUser(userId, unLockTime);
            return Result.build((ResultConstant)AuthResultEnum.ACCOUNT_LOCK);
        }
        int maxOnline = this.authProperties.getMaxOnline();
        ArrayList<String> userTokenList = (ArrayList<String>)this.cacheUtil.get("auth-cache", "auth-user-cache:" + userId);
        if (CollUtil.isNotEmpty((Collection)userTokenList)) {
            if (maxOnline >= userTokenList.size()) {
                return Result.build((ResultConstant)AuthResultEnum.USER_MAX_ONLINE);
            }
        } else {
            userTokenList = new ArrayList<String>();
        }
        UserTicket userTicket = new UserTicket();
        userTicket.setUserId(userId);
        userTicket.setAccount(userCheck.getAccount());
        userTicket.setUsername(userCheck.getUsername());
        userTicket.setLoginIp(info.getLoginIp());
        List<String> operationList = this.authService.getUserOperationList(userId);
        userTicket.setOperationList(operationList);
        List<String> permissionList = this.authService.getUserPermissionList(userId);
        userTicket.setPermissionList(permissionList);
        Object extendInfo = this.authService.getUserExtendInfo(userId);
        userTicket.setExtendInfo(extendInfo);
        long timeMillis = System.currentTimeMillis();
        String token = TokenUtil.createToken(userTicket.getUserId(), timeMillis);
        userTicket.setToken(token);
        userTicket.setCreateTime(timeMillis);
        this.cacheUtil.put("auth-cache", "auth-token-cache:" + token, (Object)userTicket);
        userTokenList.add(token);
        this.cacheUtil.put("auth-cache", "auth-user-cache:" + userId, userTokenList);
        return Result.ok((Object)userTicket);
    }

    @Override
    public void logout(String token, String userId) {
        this.cacheUtil.removeCache("auth-cache", "auth-token-cache:" + token);
        this.cacheUtil.removeCache("auth-cache", "auth-fail-cache:" + userId);
        List userTokenList = (List)this.cacheUtil.get("auth-cache", "auth-user-cache:" + userId);
        if (CollUtil.isNotEmpty((Collection)userTokenList) && userTokenList.size() >= 1) {
            userTokenList.remove(token);
            this.cacheUtil.put("auth-cache", "auth-user-cache:" + userId, (Object)userTokenList);
        } else {
            this.cacheUtil.removeCache("auth-cache", "auth-user-cache:" + userId);
        }
    }
}

