/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.auth.interceptor;

import cn.hutool.core.util.StrUtil;
import com.efficient.auth.constant.AuthResultEnum;
import com.efficient.auth.interceptor.DefaultPermissionCheck;
import com.efficient.auth.interceptor.PermissionCheck;
import com.efficient.auth.permission.Permission;
import com.efficient.auth.properties.AuthProperties;
import com.efficient.auth.util.JwtUtil;
import com.efficient.cache.api.CacheUtil;
import com.efficient.common.auth.RequestHolder;
import com.efficient.common.auth.UserTicket;
import com.efficient.common.result.ResultConstant;
import com.efficient.common.result.ResultEnum;
import com.efficient.common.util.JackSonUtil;
import com.efficient.common.util.RenderJson;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class PermissionInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(PermissionInterceptor.class);
    @Autowired
    private CacheUtil cacheUtil;
    @Autowired
    private AuthProperties authProperties;
    @Autowired
    private JwtUtil jwtUtil;
    private static PermissionCheck permissionCheck;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        boolean checkPermission;
        UserTicket userTicket;
        HandlerMethod method;
        try {
            method = (HandlerMethod)handler;
        }
        catch (ClassCastException e) {
            RenderJson.returnJson((HttpServletResponse)response, (ResultConstant)AuthResultEnum.REQUEST_PATH_ERROR);
            return false;
        }
        Permission permission = (Permission)method.getMethodAnnotation(Permission.class);
        if (Objects.isNull(permission)) {
            permission = method.getBeanType().getAnnotation(Permission.class);
        }
        if (Objects.isNull(permission)) {
            return true;
        }
        String token = request.getHeader("token");
        if (StrUtil.isBlank((CharSequence)token)) {
            RenderJson.returnJson((HttpServletResponse)response, (ResultConstant)AuthResultEnum.NOT_LOGIN);
            return false;
        }
        String jwtToken = (String)this.cacheUtil.get("auth-cache", "auth-token-cache:" + token);
        String subject = this.jwtUtil.validateToken(jwtToken);
        if (StrUtil.isBlank((CharSequence)subject)) {
            RenderJson.returnJson((HttpServletResponse)response, (ResultConstant)AuthResultEnum.NOT_LOGIN);
            return false;
        }
        if (this.jwtUtil.isNeedUpdate(jwtToken)) {
            jwtToken = this.jwtUtil.createToken(subject);
            this.cacheUtil.put("auth-cache", "auth-token-cache:" + token, (Object)jwtToken);
        }
        if ((userTicket = (UserTicket)JackSonUtil.toObject((String)subject, UserTicket.class)) == null) {
            RenderJson.returnJson((HttpServletResponse)response, (ResultConstant)AuthResultEnum.NOT_LOGIN);
            return false;
        }
        this.cacheUtil.refresh("auth-cache", "auth-token-cache:" + token, this.authProperties.getTokenLive());
        this.cacheUtil.refresh("auth-cache", "auth-user-cache:" + userTicket.getUserId(), this.authProperties.getTokenLive());
        if (Objects.isNull(permissionCheck)) {
            permissionCheck = new DefaultPermissionCheck();
        }
        if (!(checkPermission = permissionCheck.checkPermission(permission, userTicket))) {
            RenderJson.returnJson((HttpServletResponse)response, (ResultConstant)ResultEnum.NOT_PERMISSION);
            return false;
        }
        RequestHolder.set((UserTicket)userTicket);
        return true;
    }

    public static void init(PermissionCheck permissionCheck) {
        PermissionInterceptor.permissionCheck = permissionCheck;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        RequestHolder.remove();
        super.afterCompletion(request, response, handler, ex);
    }
}

