/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.auth.controller;

import cn.hutool.captcha.CaptchaUtil;
import cn.hutool.captcha.CircleCaptcha;
import cn.hutool.captcha.generator.CodeGenerator;
import cn.hutool.captcha.generator.RandomGenerator;
import cn.hutool.core.util.StrUtil;
import com.efficient.auth.api.LoginService;
import com.efficient.auth.constant.AuthResultEnum;
import com.efficient.auth.model.dto.LoginInfo;
import com.efficient.auth.permission.Permission;
import com.efficient.auth.properties.AuthProperties;
import com.efficient.cache.api.CacheUtil;
import com.efficient.common.result.Result;
import com.efficient.common.result.ResultConstant;
import com.efficient.common.util.WebUtil;
import com.efficient.logs.annotation.Log;
import com.efficient.logs.constant.LogEnum;
import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Validated
public class LoginController {
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private CacheUtil cacheUtil;
    @Autowired
    private AuthProperties authProperties;
    @Autowired
    private LoginService loginService;

    @Log(logOpt=LogEnum.LOGIN, desc="\u7cfb\u7edf")
    @PostMapping(value={"/login"})
    public Result login(@Validated @RequestBody LoginInfo info) {
        String captchaCache;
        if (this.authProperties.isCaptcha() && (StrUtil.isBlank((CharSequence)(captchaCache = (String)this.cacheUtil.get("auth-captcha-cache", info.getCaptchaId()))) || !StrUtil.equalsIgnoreCase((CharSequence)info.getCaptcha(), (CharSequence)captchaCache))) {
            return Result.build((ResultConstant)AuthResultEnum.CAPTCHA_NOT_MATCH);
        }
        String loginIp = WebUtil.getIP((HttpServletRequest)this.request);
        info.setLoginIp(loginIp);
        return this.loginService.login(info);
    }

    @Permission
    @GetMapping(value={"/logout"})
    public Result logout(@NotBlank(message="token \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(value="token") @NotBlank(message="token \u4e0d\u80fd\u4e3a\u7a7a") String token, @NotBlank(message="userId \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(value="token") @NotBlank(message="userId \u4e0d\u80fd\u4e3a\u7a7a") String userId) {
        this.loginService.logout(token, userId);
        return Result.ok();
    }

    @GetMapping(value={"/captcha"})
    public void captcha(HttpServletResponse response) {
        String uuid = UUID.randomUUID().toString() + System.nanoTime();
        RandomGenerator randomGenerator = new RandomGenerator("23456789abcdefghjkmnpqrstuvwxyz", 4);
        CircleCaptcha circleCaptcha = CaptchaUtil.createCircleCaptcha((int)120, (int)34, (int)4, (int)0);
        circleCaptcha.setGenerator((CodeGenerator)randomGenerator);
        circleCaptcha.createCode();
        this.cacheUtil.put("auth-captcha-cache", uuid, (Object)circleCaptcha.getCode());
        response.setHeader("captchaId", uuid);
        try (ServletOutputStream out = response.getOutputStream();){
            circleCaptcha.write((OutputStream)out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

