/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.auth.interceptor;

import cn.hutool.core.collection.CollUtil;
import com.efficient.auth.interceptor.PermissionCheck;
import com.efficient.common.auth.UserTicket;
import com.efficient.common.constant.MenuRelation;
import com.efficient.common.permission.Permission;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@ConditionalOnProperty(name={"com.efficient.auth.permissionCheckType"}, havingValue="default", matchIfMissing=false)
@Service
public class DefaultPermissionCheck
implements PermissionCheck {
    @Override
    public boolean checkPermission(Permission permission, UserTicket userTicket) {
        List currMenus = userTicket.getPermissionList();
        String systemId = permission.systemId();
        String[] menuEnums = permission.value();
        if (menuEnums.length <= 0) {
            return true;
        }
        if (CollUtil.isEmpty((Collection)currMenus)) {
            return false;
        }
        MenuRelation relation = permission.relation();
        if (Objects.equals(relation, MenuRelation.OR)) {
            return Arrays.stream(menuEnums).anyMatch(currMenus::contains);
        }
        return Arrays.stream(menuEnums).allMatch(currMenus::contains);
    }
}

