/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.auth.interceptor;

import cn.hutool.core.util.StrUtil;
import com.efficient.auth.constant.AuthResultEnum;
import com.efficient.auth.interceptor.PermissionCheck;
import com.efficient.auth.properties.AuthProperties;
import com.efficient.auth.util.JwtUtil;
import com.efficient.cache.api.CacheUtil;
import com.efficient.common.auth.RequestHolder;
import com.efficient.common.auth.UserTicket;
import com.efficient.common.permission.Permission;
import com.efficient.common.result.ResultConstant;
import com.efficient.common.result.ResultEnum;
import com.efficient.common.util.RenderJson;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class PermissionInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(PermissionInterceptor.class);
    @Autowired
    private PermissionCheck permissionCheck;
    @Autowired
    private CacheUtil cacheUtil;
    @Autowired
    private AuthProperties authProperties;
    @Autowired
    private JwtUtil jwtUtil;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        HandlerMethod method;
        String servletPath = request.getServletPath();
        log.info(servletPath);
        try {
            method = (HandlerMethod)handler;
        }
        catch (ClassCastException e) {
            if (Objects.nonNull(servletPath) && StrUtil.startWithAny((CharSequence)servletPath, (CharSequence[])new CharSequence[]{"/"})) {
                return true;
            }
            log.warn(AuthResultEnum.REQUEST_PATH_ERROR.getMsg());
            RenderJson.returnJson((HttpServletResponse)response, (ResultConstant)AuthResultEnum.REQUEST_PATH_ERROR);
            return false;
        }
        Permission permission = (Permission)method.getMethodAnnotation(Permission.class);
        if (Objects.isNull(permission)) {
            permission = method.getBeanType().getAnnotation(Permission.class);
        }
        if (Objects.isNull(permission)) {
            return true;
        }
        List<String> tokenGet = this.authProperties.getTokenGet();
        String token = null;
        token = StrUtil.startWithAny((CharSequence)servletPath, (CharSequence[])tokenGet.toArray(new String[0])) ? request.getParameter("token") : request.getHeader("token");
        if (StrUtil.isBlank((CharSequence)token)) {
            log.warn(AuthResultEnum.NOT_LOGIN.getMsg());
            RenderJson.returnJson((HttpServletResponse)response, (ResultConstant)AuthResultEnum.NOT_LOGIN);
            return false;
        }
        String jwtToken = (String)this.cacheUtil.get("auth-cache", "auth-token-cache:" + token);
        UserTicket userTicket = this.jwtUtil.validateToken(jwtToken, this.authProperties.getUserTicketClass());
        if (Objects.isNull(userTicket)) {
            log.warn(AuthResultEnum.NOT_LOGIN.getMsg());
            RenderJson.returnJson((HttpServletResponse)response, (ResultConstant)AuthResultEnum.NOT_LOGIN);
            return false;
        }
        int tokenLive = this.authProperties.getLogin().getTokenLive();
        if (this.jwtUtil.isNeedUpdate(jwtToken)) {
            jwtToken = this.jwtUtil.createToken(userTicket);
            this.cacheUtil.put("auth-cache", "auth-token-cache:" + token, (Object)jwtToken, tokenLive);
        }
        this.cacheUtil.refresh("auth-cache", "auth-token-cache:" + token, tokenLive);
        this.cacheUtil.refresh("auth-cache", "auth-user-cache:" + userTicket.getUserId(), tokenLive);
        boolean checkPermission = this.permissionCheck.checkPermission(permission, userTicket);
        if (!checkPermission) {
            log.warn(ResultEnum.NOT_PERMISSION.getMsg());
            RenderJson.returnJson((HttpServletResponse)response, (ResultConstant)ResultEnum.NOT_PERMISSION);
            return false;
        }
        RequestHolder.set((UserTicket)userTicket);
        RequestHolder.setCurrSystemId((String)request.getHeader(this.authProperties.getSystemIdField()));
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        RequestHolder.remove();
        super.afterCompletion(request, response, handler, ex);
    }
}

