/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.auth.controller;

import cn.hutool.captcha.CaptchaUtil;
import cn.hutool.captcha.CircleCaptcha;
import cn.hutool.captcha.generator.CodeGenerator;
import cn.hutool.captcha.generator.RandomGenerator;
import com.efficient.auth.api.LoginService;
import com.efficient.auth.constant.AuthResultEnum;
import com.efficient.auth.constant.LoginTypeEnum;
import com.efficient.auth.model.dto.LoginInfo;
import com.efficient.auth.properties.AuthProperties;
import com.efficient.cache.api.CacheUtil;
import com.efficient.cache.constant.CacheConstant;
import com.efficient.common.auth.UserTicket;
import com.efficient.common.permission.Permission;
import com.efficient.common.result.Result;
import com.efficient.common.result.ResultConstant;
import com.efficient.common.util.WebUtil;
import com.efficient.logs.annotation.Log;
import com.efficient.logs.constant.LogEnum;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.UUID;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Validated
@Api(tags={"\u7528\u6237\u767b\u5f55"})
public class LoginController {
    private static final Logger log = LoggerFactory.getLogger(LoginController.class);
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private CacheUtil cacheUtil;
    @Autowired
    private AuthProperties authProperties;
    @Autowired
    private LoginService loginService;

    @Log(logOpt=LogEnum.LOGIN, desc="\u767b\u5f55\u7cfb\u7edf")
    @PostMapping(value={"/login"})
    public Result<UserTicket> login(@Validated @RequestBody LoginInfo info) {
        boolean flag;
        if (this.authProperties.getLogin().isCaptcha() && !(flag = this.loginService.checkCaptcha(info.getCaptchaId(), info.getCaptcha()))) {
            return Result.build((ResultConstant)AuthResultEnum.CAPTCHA_NOT_MATCH);
        }
        String loginIp = WebUtil.getIP((HttpServletRequest)this.request);
        info.setLoginIp(loginIp);
        Integer loginType = info.getLoginType();
        if (Objects.isNull(loginType)) {
            info.setLoginType(LoginTypeEnum.LOGIN.getCode());
        }
        return this.loginService.login(info);
    }

    @Permission
    @Log(logOpt=LogEnum.LOGOUT, desc="\u767b\u51fa\u7cfb\u7edf")
    @GetMapping(value={"/logout"})
    public Result logout(@NotBlank(message="token \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(value="token") @NotBlank(message="token \u4e0d\u80fd\u4e3a\u7a7a") String token, @NotBlank(message="userId \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(value="token") @NotBlank(message="userId \u4e0d\u80fd\u4e3a\u7a7a") String userId) {
        this.loginService.logout(token, userId);
        return Result.ok();
    }

    @GetMapping(value={"/captcha"})
    public void captcha(HttpServletResponse response) {
        String uuid = UUID.randomUUID().toString() + System.nanoTime();
        RandomGenerator randomGenerator = new RandomGenerator(this.authProperties.getLogin().getCaptchaRule(), 4);
        CircleCaptcha circleCaptcha = CaptchaUtil.createCircleCaptcha((int)120, (int)34, (int)4, (int)0);
        circleCaptcha.setGenerator((CodeGenerator)randomGenerator);
        circleCaptcha.createCode();
        this.cacheUtil.put("auth-cache", "captcha:" + uuid, (Object)circleCaptcha.getCode(), CacheConstant.CACHE_SHORT_TIME.intValue());
        response.setHeader("captchaId", uuid);
        try (ServletOutputStream out = response.getOutputStream();){
            circleCaptcha.write((OutputStream)out);
        }
        catch (IOException e) {
            log.error("\u751f\u6210\u9a8c\u8bc1\u7801\u9519\u8bef", (Throwable)e);
        }
    }

    @GetMapping(value={"/checkCaptcha"})
    public Result<Boolean> checkCaptcha(@NotBlank(message="captchaId \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(value="captchaId") @NotBlank(message="captchaId \u4e0d\u80fd\u4e3a\u7a7a") String captchaId, @NotBlank(message="captcha \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(value="captcha") @NotBlank(message="captcha \u4e0d\u80fd\u4e3a\u7a7a") String captcha) {
        boolean flag = this.loginService.checkCaptcha(captchaId, captcha);
        return Result.ok((Object)flag);
    }
}

