/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.auth.util;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.efficient.auth.properties.AuthProperties;
import com.efficient.common.util.JackSonUtil;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JwtUtil {
    private static final Logger log = LoggerFactory.getLogger(JwtUtil.class);
    @Autowired
    AuthProperties authProperties;

    public String createToken(Object sub) {
        return JWT.create().withSubject(JackSonUtil.toJson((Object)sub)).withExpiresAt((Date)DateUtil.offset((Date)new Date(), (DateField)DateField.SECOND, (int)this.authProperties.getLogin().getTokenLive())).sign(Algorithm.HMAC512((String)this.authProperties.getLogin().getSecret()));
    }

    public String createAuthCode(Object sub) {
        return JWT.create().withSubject(JackSonUtil.toJson((Object)sub)).sign(Algorithm.HMAC512((String)this.authProperties.getLogin().getSecret()));
    }

    public <T> T validateToken(String token, Class<T> tClass) {
        if (StrUtil.isBlank((CharSequence)token)) {
            log.error("token is null");
            return null;
        }
        try {
            String subject = JWT.require((Algorithm)Algorithm.HMAC512((String)this.authProperties.getLogin().getSecret())).build().verify(token).getSubject();
            return (T)JackSonUtil.toObject((String)subject, tClass);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public boolean isNeedUpdate(String token) {
        Date expiresAt = null;
        try {
            expiresAt = JWT.require((Algorithm)Algorithm.HMAC512((String)this.authProperties.getLogin().getSecret())).build().verify(token).getExpiresAt();
        }
        catch (Exception e) {
            log.error("jwt validateToken error", (Throwable)e);
            return true;
        }
        if (Objects.isNull(expiresAt)) {
            log.info("jwt\u672a\u8bbe\u7f6e\u8fc7\u671f\u65f6\u95f4");
            return false;
        }
        return (expiresAt.getTime() - System.currentTimeMillis()) / 1000L < (long)(this.authProperties.getLogin().getTokenLive() >> 1);
    }
}

