/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.auth.properties;

import cn.hutool.core.util.StrUtil;
import com.efficient.auth.properties.LoginProperties;
import com.efficient.common.auth.UserTicket;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="com.efficient.auth")
public class AuthProperties {
    private static final Logger log = LoggerFactory.getLogger(AuthProperties.class);
    private static volatile Class<? extends UserTicket> userTicketClassInstance = null;
    private LoginProperties login = new LoginProperties();
    private String systemIdField = "systemId";
    private String permissionCheckType = "default";
    private String userTicketClassName = "com.efficient.common.auth.UserTicket";
    private List<String> whiteList = new ArrayList<String>(){
        private static final long serialVersionUID = -6831198909191678412L;
        {
            this.add("**swagger-resources**");
            this.add("/login");
            this.add("/captcha");
        }
    };
    private List<String> tokenGet = new ArrayList<String>(){
        private static final long serialVersionUID = -6831198909191678412L;
        {
            this.add("/video/play");
        }
    };
    @Deprecated
    private List<String> tokenPost = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Class<? extends UserTicket> getUserTicketClass() {
        if (userTicketClassInstance != null) return userTicketClassInstance;
        Class<AuthProperties> clazz = AuthProperties.class;
        synchronized (AuthProperties.class) {
            if (userTicketClassInstance != null) return userTicketClassInstance;
            userTicketClassInstance = this.initializeUserTicketClass();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return userTicketClassInstance;
        }
    }

    private Class<? extends UserTicket> initializeUserTicketClass() {
        if (StrUtil.equals((CharSequence)this.userTicketClassName, (CharSequence)"com.efficient.common.auth.UserTicket")) {
            return UserTicket.class;
        }
        try {
            return Class.forName(this.userTicketClassName);
        }
        catch (ClassNotFoundException e) {
            log.error("\u83b7\u53d6\u7528\u6237\u7c7b\u5f02\u5e38", (Throwable)e);
            return UserTicket.class;
        }
    }

    public LoginProperties getLogin() {
        return this.login;
    }

    public String getSystemIdField() {
        return this.systemIdField;
    }

    public String getPermissionCheckType() {
        return this.permissionCheckType;
    }

    public String getUserTicketClassName() {
        return this.userTicketClassName;
    }

    public List<String> getWhiteList() {
        return this.whiteList;
    }

    public List<String> getTokenGet() {
        return this.tokenGet;
    }

    @Deprecated
    public List<String> getTokenPost() {
        return this.tokenPost;
    }

    public void setLogin(LoginProperties login) {
        this.login = login;
    }

    public void setSystemIdField(String systemIdField) {
        this.systemIdField = systemIdField;
    }

    public void setPermissionCheckType(String permissionCheckType) {
        this.permissionCheckType = permissionCheckType;
    }

    public void setUserTicketClassName(String userTicketClassName) {
        this.userTicketClassName = userTicketClassName;
    }

    public void setWhiteList(List<String> whiteList) {
        this.whiteList = whiteList;
    }

    public void setTokenGet(List<String> tokenGet) {
        this.tokenGet = tokenGet;
    }

    @Deprecated
    public void setTokenPost(List<String> tokenPost) {
        this.tokenPost = tokenPost;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthProperties)) {
            return false;
        }
        AuthProperties other = (AuthProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LoginProperties this$login = this.getLogin();
        LoginProperties other$login = other.getLogin();
        if (this$login == null ? other$login != null : !((Object)this$login).equals(other$login)) {
            return false;
        }
        String this$systemIdField = this.getSystemIdField();
        String other$systemIdField = other.getSystemIdField();
        if (this$systemIdField == null ? other$systemIdField != null : !this$systemIdField.equals(other$systemIdField)) {
            return false;
        }
        String this$permissionCheckType = this.getPermissionCheckType();
        String other$permissionCheckType = other.getPermissionCheckType();
        if (this$permissionCheckType == null ? other$permissionCheckType != null : !this$permissionCheckType.equals(other$permissionCheckType)) {
            return false;
        }
        String this$userTicketClassName = this.getUserTicketClassName();
        String other$userTicketClassName = other.getUserTicketClassName();
        if (this$userTicketClassName == null ? other$userTicketClassName != null : !this$userTicketClassName.equals(other$userTicketClassName)) {
            return false;
        }
        List<String> this$whiteList = this.getWhiteList();
        List<String> other$whiteList = other.getWhiteList();
        if (this$whiteList == null ? other$whiteList != null : !((Object)this$whiteList).equals(other$whiteList)) {
            return false;
        }
        List<String> this$tokenGet = this.getTokenGet();
        List<String> other$tokenGet = other.getTokenGet();
        if (this$tokenGet == null ? other$tokenGet != null : !((Object)this$tokenGet).equals(other$tokenGet)) {
            return false;
        }
        List<String> this$tokenPost = this.getTokenPost();
        List<String> other$tokenPost = other.getTokenPost();
        return !(this$tokenPost == null ? other$tokenPost != null : !((Object)this$tokenPost).equals(other$tokenPost));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LoginProperties $login = this.getLogin();
        result = result * 59 + ($login == null ? 43 : ((Object)$login).hashCode());
        String $systemIdField = this.getSystemIdField();
        result = result * 59 + ($systemIdField == null ? 43 : $systemIdField.hashCode());
        String $permissionCheckType = this.getPermissionCheckType();
        result = result * 59 + ($permissionCheckType == null ? 43 : $permissionCheckType.hashCode());
        String $userTicketClassName = this.getUserTicketClassName();
        result = result * 59 + ($userTicketClassName == null ? 43 : $userTicketClassName.hashCode());
        List<String> $whiteList = this.getWhiteList();
        result = result * 59 + ($whiteList == null ? 43 : ((Object)$whiteList).hashCode());
        List<String> $tokenGet = this.getTokenGet();
        result = result * 59 + ($tokenGet == null ? 43 : ((Object)$tokenGet).hashCode());
        List<String> $tokenPost = this.getTokenPost();
        result = result * 59 + ($tokenPost == null ? 43 : ((Object)$tokenPost).hashCode());
        return result;
    }

    public String toString() {
        return "AuthProperties(login=" + this.getLogin() + ", systemIdField=" + this.getSystemIdField() + ", permissionCheckType=" + this.getPermissionCheckType() + ", userTicketClassName=" + this.getUserTicketClassName() + ", whiteList=" + this.getWhiteList() + ", tokenGet=" + this.getTokenGet() + ", tokenPost=" + this.getTokenPost() + ")";
    }
}

