/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.cache.util;

import com.efficient.cache.api.CacheUtil;
import com.efficient.cache.exception.CacheException;
import java.io.Serializable;
import java.util.Objects;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;

public class EhCacheUtil
implements CacheUtil {
    private CacheManager cacheManager;

    public void init(CacheManager manager) {
        this.cacheManager = manager;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public <T> T get(String cacheName, String key) {
        Cache cache = this.cacheManager.getCache(cacheName);
        if (cache == null) {
            return null;
        }
        Element element = cache.get((Serializable)((Object)key));
        if (Objects.isNull(element)) {
            return null;
        }
        return (T)element.getObjectValue();
    }

    @Override
    public void put(String cacheName, String key, Object obj) {
        Cache cache = this.cacheManager.getCache(cacheName);
        if (cache == null) {
            throw new CacheException("cacheName not exist\uff01");
        }
        cache.put(new Element((Object)key, obj));
    }

    @Override
    public void put(String cacheName, String key, Object obj, int timeToIdleSeconds) {
        this.put(cacheName, key, obj);
        this.refresh(cacheName, key, timeToIdleSeconds);
    }

    @Override
    public void refresh(String cacheName, String key, int timeToIdleSeconds) {
        Cache cache = this.cacheManager.getCache(cacheName);
        if (cache == null) {
            throw new CacheException("cacheName not exist\uff01");
        }
        cache.get((Serializable)((Object)key)).setTimeToIdle(timeToIdleSeconds);
    }

    @Override
    public int getTimeToIdleSeconds(String cacheName, String key) {
        Cache cache = this.cacheManager.getCache(cacheName);
        if (cache == null) {
            throw new CacheException("cacheName not exist\uff01");
        }
        return cache.get((Serializable)((Object)key)).getTimeToIdle();
    }

    @Override
    public void removeCache(String cacheName, String key) {
        Cache cache = this.cacheManager.getCache(cacheName);
        if (Objects.nonNull(cache)) {
            cache.remove((Serializable)((Object)key));
        }
    }

    @Override
    public void removeCache(String cacheName) {
        this.cacheManager.removeCache(cacheName);
    }
}

