/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.cache.util;

import cn.hutool.core.collection.CollUtil;
import com.efficient.cache.api.CacheUtil;
import java.time.Duration;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisUtil
implements CacheUtil {
    private RedisTemplate<String, Object> redisTemplate;
    private static final String CONNECTOR_STR = "-";

    @PostConstruct
    public void postConstruct() {
        this.init(this.redisTemplate);
    }

    public void init(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    @Override
    public <T> T get(String cacheName, String key) {
        return (T)this.redisTemplate.opsForValue().get((Object)(cacheName + CONNECTOR_STR + key));
    }

    @Override
    public void put(String cacheName, String key, Object obj) {
        this.redisTemplate.opsForValue().set((Object)(cacheName + CONNECTOR_STR + key), obj);
    }

    @Override
    public void put(String cacheName, String key, Object obj, int timeToIdleSeconds) {
        this.redisTemplate.opsForValue().set((Object)(cacheName + CONNECTOR_STR + key), obj, Duration.ofSeconds(timeToIdleSeconds));
    }

    @Override
    public void refresh(String cacheName, String key, int timeToIdleSeconds) {
        this.redisTemplate.expire((Object)(cacheName + CONNECTOR_STR + key), Duration.ofSeconds(timeToIdleSeconds));
    }

    @Override
    public int getTimeToIdleSeconds(String cacheName, String key) {
        Long expire = this.redisTemplate.opsForValue().getOperations().getExpire((Object)(cacheName + CONNECTOR_STR + key));
        if (Objects.isNull(expire)) {
            return -1;
        }
        return expire.intValue();
    }

    @Override
    public void removeCache(String cacheName, String key) {
        this.redisTemplate.delete((Object)(cacheName + CONNECTOR_STR + key));
    }

    @Override
    public void removeCache(String cacheName) {
        Set keys = this.redisTemplate.keys((Object)(cacheName + "*"));
        if (CollUtil.isNotEmpty((Collection)keys)) {
            keys.forEach(key -> this.redisTemplate.delete(key));
        }
    }
}

