/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.cache.config;

import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.codec.JsonJacksonCodec;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"com.efficient.cache.active"}, havingValue="redis", matchIfMissing=false)
public class RedissonConfig {
    @Value(value="${spring.redis.host}")
    private String redisHost;
    @Value(value="${spring.redis.password}")
    private String password;
    @Value(value="${spring.redis.port}")
    private int port;
    @Value(value="${spring.redis.database}")
    private int database;

    @Bean
    public RedissonClient getRedisson() {
        Config config = new Config();
        ((SingleServerConfig)config.useSingleServer().setAddress("redis://" + this.redisHost + ":" + this.port).setPassword(this.password)).setDatabase(this.database);
        config.setCodec((Codec)new JsonJacksonCodec());
        return Redisson.create((Config)config);
    }
}

