/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.cache.config;

import cn.hutool.core.util.StrUtil;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.codec.JsonJacksonCodec;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"com.efficient.cache.active"}, havingValue="redis", matchIfMissing=false)
public class RedissonConfig {
    private static final Logger log = LoggerFactory.getLogger(RedissonConfig.class);
    @Value(value="${spring.redis.host}")
    private String redisHost;
    @Value(value="${spring.redis.password}")
    private String password;
    @Value(value="${spring.redis.port}")
    private int port;
    @Value(value="${spring.redis.database:0}")
    private int database;
    @Value(value="${spring.redis.ssl:false}")
    private boolean ssl;
    @Value(value="${com.efficient.cache.redis.customRedisson:false}")
    private boolean customRedisson;
    @Value(value="${com.efficient.cache.redis.redissonUrl:null}")
    private String redissonUrl;

    @Bean
    @ConditionalOnProperty(name={"com.efficient.cache.redis.enableRedisson"}, havingValue="true", matchIfMissing=false)
    public RedissonClient getRedisson() {
        Config config = new Config();
        try {
            SingleServerConfig singleServerConfig = config.useSingleServer();
            ((SingleServerConfig)singleServerConfig.setSslEnableEndpointIdentification(this.ssl)).setTimeout(5000);
            if (this.customRedisson) {
                singleServerConfig.setAddress(this.redissonUrl);
            } else {
                singleServerConfig.setAddress("redis://" + this.redisHost + ":" + this.port).setDatabase(this.database);
                if (StrUtil.isNotBlank((CharSequence)this.password)) {
                    singleServerConfig.setPassword(this.password);
                }
            }
            config.setCodec((Codec)new JsonJacksonCodec());
        }
        catch (Exception e) {
            log.error("Create Redisson Error!", (Throwable)e);
        }
        log.info("Create Redisson Success !");
        return Redisson.create((Config)config);
    }
}

