/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.cache.util;

import com.efficient.cache.api.CacheUtil;
import com.efficient.cache.constant.CacheConstant;
import com.efficient.cache.constant.ProgressStatus;
import com.efficient.cache.vo.DataProgressVO;
import java.text.NumberFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProgressUtil {
    @Autowired
    private CacheUtil cacheUtil;

    public static String getCurrKey(String methodName, String token) {
        return methodName + "-" + token + System.currentTimeMillis();
    }

    public void running(String currDataName, double ratio, String key) {
        String result = ProgressUtil.getNumFormat().format(ratio);
        DataProgressVO progressVo = new DataProgressVO();
        progressVo.setCurrDataName(currDataName);
        progressVo.setRatio(result);
        progressVo.setCode(ProgressStatus.RUNNING.getCode());
        this.cacheUtil.put("system-cache", "progress-cache:" + key, progressVo, CacheConstant.CACHE_COMMON_TIME);
    }

    public static NumberFormat getNumFormat() {
        NumberFormat num = NumberFormat.getInstance();
        num.setMaximumFractionDigits(2);
        return num;
    }

    public void running(String currDataName, double ratio, String key, int timeToIdleSeconds) {
        String result = ProgressUtil.getNumFormat().format(ratio);
        DataProgressVO progressVo = new DataProgressVO();
        progressVo.setCurrDataName(currDataName);
        progressVo.setRatio(result);
        progressVo.setCode(ProgressStatus.RUNNING.getCode());
        this.cacheUtil.put("system-cache", "progress-cache:" + key, progressVo, timeToIdleSeconds);
    }

    public void success(String currDataName, String key) {
        this.success(currDataName, key, null);
    }

    public void success(String currDataName, String key, Object object) {
        String result = ProgressUtil.getNumFormat().format(100L);
        DataProgressVO progressVo = new DataProgressVO();
        progressVo.setCurrDataName(currDataName);
        progressVo.setRatio(result);
        if (object != null) {
            progressVo.setData(object);
        }
        progressVo.setCode(ProgressStatus.SUCCESS.getCode());
        this.cacheUtil.put("system-cache", "progress-cache:" + key, progressVo, CacheConstant.CACHE_SHORT_TIME);
    }

    public DataProgressVO getByKey(String key) {
        return (DataProgressVO)this.cacheUtil.get("system-cache", "progress-cache:" + key);
    }

    public void fail(String currDataName, String key) {
        this.fail(currDataName, key, null);
    }

    public void fail(String currDataName, String key, Object object) {
        String result = ProgressUtil.getNumFormat().format(100L);
        DataProgressVO progressVo = new DataProgressVO();
        progressVo.setCurrDataName(currDataName);
        progressVo.setRatio(result);
        if (object != null) {
            progressVo.setData(object);
        }
        progressVo.setCode(ProgressStatus.FAIL.getCode());
        this.cacheUtil.put("system-cache", "progress-cache:" + key, progressVo, CacheConstant.CACHE_SHORT_TIME);
    }
}

