/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.common.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class ExceptionUtil {
    public static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static Throwable getRootCause(Throwable throwable) {
        List<Throwable> list = ExceptionUtil.getThrowableList(throwable);
        return list.size() < 2 ? throwable : list.get(list.size() - 1);
    }

    public static List<Throwable> getThrowableList(Throwable throwable) {
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        while (throwable != null && !throwables.contains(throwable)) {
            throwables.add(throwable);
            throwable = throwable.getCause();
        }
        return throwables;
    }

    public static boolean containsType(Throwable throwable, Class<?> clazz) {
        if (throwable == null || clazz == null) {
            return false;
        }
        for (Throwable cause = throwable; cause != null; cause = cause.getCause()) {
            if (!clazz.isInstance(cause)) continue;
            return true;
        }
        return false;
    }

    public static String getMessage(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        String message = throwable.getMessage();
        return message != null ? message : throwable.getClass().getSimpleName();
    }
}

