/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.common.result;

import com.efficient.common.result.ResultConstant;
import com.efficient.common.result.ResultEnum;
import java.io.Serializable;

public class Result<T>
implements Serializable {
    private static final long serialVersionUID = 1598014388149858217L;
    private Integer code;
    private String msg;
    private T data;

    public Result(Integer code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public Result(ResultConstant resultEnum, T data) {
        this.code = resultEnum.getCode();
        this.msg = resultEnum.getMsg();
        this.data = data;
    }

    public static <T> Result<T> ok() {
        return new Result<Object>(ResultEnum.SUCCESS, null);
    }

    public static <T> Result<T> ok(T data) {
        return new Result<T>(ResultEnum.SUCCESS, data);
    }

    public static <T> Result<T> ok(Integer code, String msg, T data) {
        return new Result<T>(code, msg, data);
    }

    public static <T> Result<T> fail() {
        return new Result<Object>(ResultEnum.FAILED, null);
    }

    public static <T> Result<T> fail(T data) {
        return new Result<T>(ResultEnum.FAILED, data);
    }

    public static <T> Result<T> fail(Integer code, String msg, T data) {
        return new Result<T>(code, msg, data);
    }

    public static <T> Result<T> build(Integer code, String msg, T data) {
        return new Result<T>(code, msg, data);
    }

    public static <T> Result<T> build(Integer code, String msg) {
        return new Result<Object>(code, msg, null);
    }

    public static <T> Result<T> build(ResultConstant resultEnum, T data) {
        return new Result<T>(resultEnum, data);
    }

    public static <T> Result<T> build(ResultConstant resultEnum) {
        return new Result<Object>(resultEnum, null);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }
}

