/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.common.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.efficient.common.util.BeanUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;

public class ExcelUtil {
    public static String FONT_SONG = "\u5b8b\u4f53";

    public static HSSFRow getRow(HSSFSheet sheet, Integer rowIndex) {
        HSSFRow row = sheet.getRow(rowIndex.intValue());
        if (Objects.isNull(row)) {
            row = sheet.createRow(rowIndex.intValue());
        }
        return row;
    }

    public static HSSFCell gtCell(HSSFRow row, Integer cellIndex) {
        HSSFCell cell = row.getCell(cellIndex.intValue());
        if (Objects.isNull(cell)) {
            cell = row.createCell(cellIndex.intValue());
        }
        return cell;
    }

    public static HSSFCell getCell(HSSFRow row, Integer cellIndex, CellStyle style) {
        HSSFCell cell = row.getCell(cellIndex.intValue());
        if (Objects.isNull(cell)) {
            cell = row.createCell(cellIndex.intValue());
        }
        cell.setCellStyle(style);
        return cell;
    }

    public static void setCell(HSSFCell cell, Object value) {
        if (Objects.isNull(value)) {
            cell.setCellValue("");
        } else {
            cell.setCellValue(String.valueOf(value));
        }
    }

    public static void setCell(HSSFCell cell, Object value, CellStyle style) {
        if (Objects.isNull(value) || StrUtil.equals((CharSequence)value.toString(), (CharSequence)"null")) {
            cell.setCellValue("");
        } else {
            cell.setCellValue(String.valueOf(value));
        }
        cell.setCellStyle(style);
    }

    public static CellStyle getCellStyle(HSSFWorkbook workbook, int fontHeight) {
        return ExcelUtil.getCellStyle(workbook, FONT_SONG, fontHeight);
    }

    public static CellStyle getCellStyle(HSSFWorkbook workbook, String fontName, int fontHeight) {
        HSSFCellStyle css = workbook.createCellStyle();
        HSSFDataFormat format = workbook.createDataFormat();
        css.setDataFormat(format.getFormat("@"));
        HSSFFont font = workbook.createFont();
        font.setFontName(fontName);
        font.setFontHeight((short)fontHeight);
        css.setFont((Font)font);
        css.setAlignment(HorizontalAlignment.CENTER);
        css.setVerticalAlignment(VerticalAlignment.CENTER);
        ExcelUtil.setBorder((CellStyle)css);
        return css;
    }

    public static void setBorder(CellStyle css) {
        css.setBorderTop(BorderStyle.THIN);
        css.setBorderRight(BorderStyle.THIN);
        css.setBorderBottom(BorderStyle.THIN);
        css.setBorderLeft(BorderStyle.THIN);
    }

    public static void writeForeach(HSSFWorkbook workbook, HSSFSheet sheet, Integer rowIndex, List<Map<String, String>> mapList) {
        for (Map<String, String> map : mapList) {
            int cellCount = 0;
            for (String value : map.values()) {
                ExcelUtil.setCell(ExcelUtil.getCell(ExcelUtil.getRow(sheet, rowIndex), cellCount), value);
                ++cellCount;
            }
            Integer n = rowIndex;
            Integer n2 = rowIndex = Integer.valueOf(rowIndex + 1);
        }
    }

    public static File write(String tempFilePath, String targetFilePath, List<?> list) throws Exception {
        return ExcelUtil.write(tempFilePath, targetFilePath, null, null, null, null, list);
    }

    public static File write(String tempFilePath, String targetFilePath, String title, List<String> remarkList, List<?> list) throws Exception {
        return ExcelUtil.write(tempFilePath, targetFilePath, title, remarkList, null, null, list);
    }

    public static File write(String tempFilePath, String targetFilePath, String title, List<CellRangeAddress> rangeAddList, List<?> rangeList, List<?> list) throws Exception {
        return ExcelUtil.write(tempFilePath, targetFilePath, title, null, rangeAddList, rangeList, list);
    }

    public static File write(String tempFilePath, String targetFilePath, String title, List<String> remarkList, List<CellRangeAddress> rangeAddList, List<?> rangeList, List<?> list) throws Exception {
        CellRangeAddress cellAddresses;
        FileInputStream inp = new FileInputStream(tempFilePath);
        HSSFWorkbook workbook = new HSSFWorkbook((InputStream)inp);
        HSSFSheet sheet = workbook.getSheetAt(0);
        if (StrUtil.isNotBlank((CharSequence)title)) {
            HSSFRow row0 = ExcelUtil.getRow(sheet, 0);
            HSSFCell cell01 = row0.getCell(0);
            cell01.setCellValue(title);
            workbook.setSheetName(0, title);
        }
        int lastRowNum = sheet.getLastRowNum();
        HSSFCellStyle cellStyleOld = ExcelUtil.getRow(sheet, lastRowNum - 1).getCell(0).getCellStyle();
        HSSFFont font = cellStyleOld.getFont((Workbook)workbook);
        String fontName = font.getFontName();
        short fontHeight = font.getFontHeight();
        CellStyle cellStyle = ExcelUtil.getCellStyle(workbook, fontName, fontHeight);
        if (CollUtil.isNotEmpty(rangeAddList) && CollUtil.isNotEmpty(rangeList) && rangeAddList.size() == rangeList.size()) {
            List<Map<String, String>> rangeMapList = BeanUtil.beanListToMap(rangeList, "yyyy-MM-dd");
            for (int i = 0; i < rangeAddList.size(); ++i) {
                Map<String, String> rangeMap = rangeMapList.get(i);
                cellAddresses = rangeAddList.get(i);
                sheet.addMergedRegion(cellAddresses);
                int firstColumn = cellAddresses.getFirstColumn();
                int lastColumn = cellAddresses.getLastColumn();
                int lastRow = cellAddresses.getLastRow();
                HSSFRow row = ExcelUtil.getRow(sheet, lastRow);
                AtomicInteger count = new AtomicInteger(0);
                rangeMap.forEach((k, v) -> {
                    int countFor = count.get();
                    if (countFor > lastColumn || countFor == firstColumn) {
                        ExcelUtil.setCell(ExcelUtil.getCell(row, countFor), v, cellStyle);
                    }
                    count.incrementAndGet();
                });
            }
            lastRowNum += rangeAddList.size() + 1;
        } else {
            ++lastRowNum;
        }
        int cellCount = 0;
        if (CollUtil.isNotEmpty(list)) {
            List<Map<String, String>> mapList = BeanUtil.beanListToMap(list, "yyyy-MM-dd");
            cellCount = mapList.get(0).size();
            ExcelUtil.writeForeachWithStyle(workbook, sheet, lastRowNum, mapList, cellStyle);
            lastRowNum += mapList.size();
        }
        if (CollUtil.isNotEmpty(remarkList)) {
            for (String remark : remarkList) {
                cellAddresses = new CellRangeAddress(lastRowNum, lastRowNum, 0, cellCount);
                sheet.addMergedRegion(cellAddresses);
                HSSFRow row = ExcelUtil.getRow(sheet, lastRowNum);
                HSSFCell cell = ExcelUtil.getCell(row, 0);
                cell.setCellValue(remark);
                ++lastRowNum;
            }
        }
        FileOutputStream out = new FileOutputStream(targetFilePath);
        workbook.write((OutputStream)out);
        out.close();
        workbook.close();
        return new File(targetFilePath);
    }

    public static void writeForeachWithStyle(HSSFWorkbook workbook, HSSFSheet sheet, Integer rowIndex, List<Map<String, String>> mapList, CellStyle style) {
        for (Map<String, String> map : mapList) {
            int cellCount = 0;
            for (String value : map.values()) {
                ExcelUtil.setCell(ExcelUtil.getCell(ExcelUtil.getRow(sheet, rowIndex), cellCount), value, style);
                ++cellCount;
            }
            Integer n = rowIndex;
            Integer n2 = rowIndex = Integer.valueOf(rowIndex + 1);
        }
    }

    private static HSSFRow createRow(HSSFSheet sheet, Integer rowIndex) {
        HSSFRow row = null;
        if (sheet.getRow(rowIndex.intValue()) != null) {
            int lastRowNo = sheet.getLastRowNum();
            sheet.shiftRows(rowIndex.intValue(), lastRowNo, 1);
        }
        row = sheet.createRow(rowIndex.intValue());
        return row;
    }

    private static void removeRow(HSSFSheet sheet, Integer rowIndex) {
        if (sheet.getRow(rowIndex.intValue()) != null) {
            int lastRowNo = sheet.getLastRowNum();
            sheet.shiftRows(rowIndex.intValue(), lastRowNo, -1);
        }
    }

    public static HSSFCell getCell(HSSFRow row, Integer cellIndex) {
        HSSFCell cell = row.getCell(cellIndex.intValue());
        if (Objects.isNull(cell)) {
            cell = row.createCell(cellIndex.intValue());
        }
        return cell;
    }
}

