/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.common.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.efficient.common.entity.HotWord;
import com.hankcs.hanlp.dictionary.CustomDictionary;
import com.hankcs.hanlp.dictionary.stopword.CoreStopWordDictionary;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.tokenizer.StandardTokenizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class HotWordUtil {
    public static List<String> stopList = new ArrayList<String>();

    public static void wordInit(List<String> customDictList, List<String> stopDictList) {
        if (CollUtil.isNotEmpty(customDictList)) {
            customDictList.forEach(CustomDictionary::add);
        }
        if (CollUtil.isNotEmpty(stopDictList)) {
            stopList = stopDictList;
        }
    }

    public static List<HotWord> analyse(String content) {
        if (StrUtil.isBlank((CharSequence)content)) {
            return null;
        }
        List termList = CoreStopWordDictionary.apply((List)StandardTokenizer.segment((String)content));
        HashMap<String, Integer> pplHashMap = new HashMap<String, Integer>();
        HashMap<String, String> pplFlagMap = new HashMap<String, String>();
        ArrayList<HotWord> result = new ArrayList<HotWord>();
        for (Term term : termList) {
            if (term.nature.startsWith('m') || term.nature.startsWith('q') || term.nature.startsWith('t') || term.nature.startsWith("w") || CoreStopWordDictionary.contains((String)term.word) || stopList.contains(term.word)) continue;
            pplFlagMap.put(term.word, term.nature.toString());
            if (!pplHashMap.containsKey(term.word)) {
                pplHashMap.put(term.word, 1);
                continue;
            }
            int tmp_count = (Integer)pplHashMap.get(term.word);
            pplHashMap.put(term.word, tmp_count + 1);
        }
        pplHashMap.forEach((k, v) -> {
            HotWord hotWord = new HotWord();
            hotWord.setWord((String)k);
            hotWord.setNature((String)pplFlagMap.get(k));
            hotWord.setCount((Integer)v);
            result.add(hotWord);
        });
        return result;
    }
}

