/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.common.util;

import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonUtil {
    private static final Logger log = LoggerFactory.getLogger(RedissonUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, R> R execute(RedissonClient redissonClient, String lockName, T param, Function<T, R> successFunc, Function<T, R> failFun) {
        RLock rLock = redissonClient.getLock(lockName);
        boolean isLocked = false;
        try {
            isLocked = rLock.tryLock(3L, 3L, TimeUnit.SECONDS);
            if (isLocked) {
                log.info("\u5206\u5e03\u5f0f\u9501\uff1a{},\u6267\u884csuccessFunc", (Object)lockName);
                R r = successFunc.apply(param);
                return r;
            }
            log.info("\u5206\u5e03\u5f0f\u9501\uff1a{},\u6267\u884cfailFun", (Object)lockName);
            R r = failFun.apply(param);
            return r;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25\uff1a{}", (Object)lockName, (Object)e);
        }
        finally {
            if (rLock.isHeldByCurrentThread()) {
                rLock.unlock();
                log.info("\u91ca\u653e\u5206\u5e03\u5f0f\u9501\u6210\u529f\uff1a{}", (Object)lockName);
            }
        }
        return null;
    }
}

