/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.common.util;

import cn.hutool.core.date.DateUtil;
import com.efficient.common.annotation.ExportSort;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class BeanUtil {
    public static List<Map<String, String>> beanListToMap(List<?> list, String format) {
        ArrayList<Map<String, String>> mapList = new ArrayList<Map<String, String>>(list.size());
        for (Object obj : list) {
            mapList.add(BeanUtil.beanToMap(obj, format, true));
        }
        return mapList;
    }

    public static Map<String, String> beanToMap(Object obj, String format, boolean hasNull) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Field[] declaredFields = obj.getClass().getDeclaredFields();
        List<Field> sortList = Arrays.stream(declaredFields).filter(field -> Objects.nonNull(field.getAnnotation(ExportSort.class))).sorted(Comparator.comparingInt(field -> field.getAnnotation(ExportSort.class).value())).collect(Collectors.toList());
        sortList.forEach(field -> {
            try {
                field.setAccessible(true);
                Object value = field.get(obj);
                if (!hasNull && Objects.isNull(value)) {
                    return;
                }
                if (field.getType() == Date.class) {
                    map.put(field.getName(), DateUtil.format((Date)((Date)value), (String)format));
                } else {
                    map.put(field.getName(), String.valueOf(value));
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        });
        return map;
    }
}

