/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.common.util;

import cn.hutool.core.util.StrUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.wltea.analyzer.cfg.Configuration;
import org.wltea.analyzer.cfg.DefaultConfig;
import org.wltea.analyzer.core.IKSegmenter;
import org.wltea.analyzer.core.Lexeme;

public class HotWordUtil {
    public static Map<String, Integer> countTermFrequency(String content, Boolean useSmart) throws IOException {
        Lexeme lexeme;
        HashMap<String, Integer> frequencies = new HashMap<String, Integer>();
        if (StrUtil.isBlank((CharSequence)content)) {
            return frequencies;
        }
        DefaultConfig conf = new DefaultConfig();
        conf.setUseSmart(useSmart.booleanValue());
        IKSegmenter ikSegmenter = new IKSegmenter((Reader)new StringReader(content), (Configuration)conf);
        while ((lexeme = ikSegmenter.next()) != null) {
            if (lexeme.getLexemeText().length() <= 1) continue;
            String term = lexeme.getLexemeText();
            frequencies.compute(term, (k, v) -> {
                v = v == null ? Integer.valueOf(1) : Integer.valueOf(v + 1);
                return v;
            });
        }
        return frequencies;
    }

    public static Map<String, Integer[]> countTFDF(List<String> docs, boolean useSmart) throws IOException {
        HashMap<String, Integer[]> frequencies = new HashMap<String, Integer[]>();
        for (String doc : docs) {
            Lexeme lexeme;
            if (StrUtil.isBlank((CharSequence)doc)) continue;
            DefaultConfig conf = new DefaultConfig();
            conf.setUseSmart(useSmart);
            IKSegmenter ikSegmenter = new IKSegmenter((Reader)new StringReader(doc), (Configuration)conf);
            HashSet<String> terms = new HashSet<String>();
            while ((lexeme = ikSegmenter.next()) != null) {
                if (lexeme.getLexemeText().length() <= 1) continue;
                String text = lexeme.getLexemeText();
                frequencies.compute(text, (k, v) -> {
                    if (v == null) {
                        v = new Integer[]{1, 0};
                    } else {
                        Integer[] integerArray = v;
                        Integer.valueOf(integerArray[0] + 1);
                    }
                    return v;
                });
                terms.add(text);
            }
            for (String term : terms) {
                Integer[] integerArray = (Integer[])frequencies.get(term);
                Integer.valueOf(integerArray[1] + 1);
            }
        }
        return frequencies;
    }

    public static Map<String, Integer> order(Map<String, Integer> data, int topN) {
        return data.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).skip(0L).limit(topN).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }
}

