/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.common.util;

import com.aspose.cells.DocxSaveOptions;
import com.aspose.cells.FontConfigs;
import com.aspose.cells.License;
import com.aspose.cells.PdfSaveOptions;
import com.aspose.cells.SaveOptions;
import com.aspose.cells.Workbook;
import com.aspose.words.Document;
import com.efficient.common.util.AsposeLicense;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class AsposeUtil {
    public static void excelToPdf(String excelPath, String pdfPath) throws Exception {
        Workbook workbook = new Workbook(excelPath);
        PdfSaveOptions pdfSaveOptions = new PdfSaveOptions();
        pdfSaveOptions.setOnePagePerSheet(true);
        workbook.save(pdfPath, (SaveOptions)pdfSaveOptions);
    }

    public static void excelToWord(String excelPath, String wordPath) throws Exception {
        Workbook workbook = new Workbook(excelPath);
        DocxSaveOptions docxSaveOptions = new DocxSaveOptions();
        docxSaveOptions.setMergeAreas(true);
        workbook.save(wordPath, 62);
    }

    public static void doc2pdf(String inPath, String outPath) {
        FileOutputStream os = null;
        try {
            File file = new File(outPath);
            os = new FileOutputStream(file);
            Document doc = new Document(inPath);
            doc.save((OutputStream)os, 40);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static void excel2pdf(String sourcePath, String targetPath) {
        FileOutputStream os = null;
        try {
            FontConfigs.setDefaultFontName((String)"\u5b8b\u4f53");
            File targetPdfFile = new File(targetPath);
            os = new FileOutputStream(targetPdfFile);
            Workbook wb = new Workbook(sourcePath);
            PdfSaveOptions options = new PdfSaveOptions();
            options.setOnePagePerSheet(true);
            options.setCheckFontCompatibility(true);
            options.setFontSubstitutionCharGranularity(true);
            wb.save((OutputStream)os, (SaveOptions)options);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static {
        try {
            License license = new License();
            license.setLicense(AsposeLicense.getInputStream());
            com.aspose.words.License licenseWord = new com.aspose.words.License();
            licenseWord.setLicense(AsposeLicense.getInputStream());
        }
        catch (Exception var2) {
            var2.printStackTrace();
            throw new RuntimeException(var2);
        }
    }
}

