/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.common.util;

import cn.hutool.core.collection.CollUtil;
import com.efficient.common.entity.TreeNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Collectors;

public class TreeUtil {
    private static final Long LAST_ORDER = 9999L;

    public static List<TreeNode> createListTree(List<TreeNode> nodeList) {
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>();
        HashMap childrenMap = new HashMap();
        List<Object> rootNodes = new ArrayList();
        for (TreeNode node : nodeList) {
            nodeMap.put(node.getId(), node);
            String parentId = node.getParentId();
            if (node.getIsRoot() != null && node.getIsRoot().booleanValue()) {
                rootNodes.add(node);
                continue;
            }
            childrenMap.computeIfAbsent(parentId, k -> new ArrayList()).add(node);
        }
        rootNodes = rootNodes.stream().sorted(Comparator.comparing(TreeNode::getOrder, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(TreeNode::getId)).collect(Collectors.toList());
        Stack<Object> stack = new Stack<Object>();
        stack.addAll(rootNodes);
        while (!stack.isEmpty()) {
            TreeNode parentNode = (TreeNode)stack.pop();
            List<TreeNode> childrenList = childrenMap.getOrDefault(parentNode.getId(), Collections.emptyList());
            if (CollUtil.isNotEmpty(childrenList)) {
                childrenList = childrenList.stream().sorted(Comparator.comparing(TreeNode::getOrder, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(TreeNode::getId)).collect(Collectors.toList());
                parentNode.setChildren(childrenList);
                stack.addAll(childrenList);
                parentNode.setIsLeaf(false);
                continue;
            }
            parentNode.setIsLeaf(true);
        }
        return rootNodes;
    }

    private static void setChildren(TreeNode parentNode, Map<String, List<TreeNode>> childrenMap) {
        List<TreeNode> childrenList = childrenMap.getOrDefault(parentNode.getId(), Collections.emptyList());
        parentNode.setChildren(childrenList);
        for (TreeNode child : childrenList) {
            TreeUtil.setChildren(child, childrenMap);
        }
    }

    public static TreeNode createTree(List<TreeNode> nodeList) {
        List<TreeNode> listTree = TreeUtil.createListTree(nodeList);
        return listTree.get(0);
    }
}

