/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.common.util;

import com.warrenstrange.googleauth.GoogleAuthenticator;
import com.warrenstrange.googleauth.GoogleAuthenticatorConfig;
import com.warrenstrange.googleauth.GoogleAuthenticatorKey;

public class TwoFactorAuthUtil {
    private static GoogleAuthenticator googleAuthenticator;

    public static void main(String[] args) {
        GoogleAuthenticatorKey key = TwoFactorAuthUtil.generateSecretKey();
        String secretKey = key.getKey();
        System.out.println("Secret Key: " + secretKey);
        int otp = TwoFactorAuthUtil.generateOneTimePassword(secretKey);
        System.out.println("Generated One-Time Password: " + otp);
        boolean isValid = TwoFactorAuthUtil.verifyCode(secretKey, otp);
        System.out.println("Is the code valid? " + isValid);
    }

    public static GoogleAuthenticatorKey generateSecretKey() {
        return googleAuthenticator.createCredentials();
    }

    public static int generateOneTimePassword(String secretKey) {
        return googleAuthenticator.getTotpPassword(secretKey);
    }

    public static boolean verifyCode(String secretKey, int code) {
        return googleAuthenticator.authorize(secretKey, code);
    }

    static {
        GoogleAuthenticatorConfig.GoogleAuthenticatorConfigBuilder configBuilder = new GoogleAuthenticatorConfig.GoogleAuthenticatorConfigBuilder();
        googleAuthenticator = new GoogleAuthenticator(configBuilder.build());
    }
}

