/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.common.entity;

import cn.hutool.core.date.DateUtil;
import com.efficient.common.util.JackSonUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Record
implements Serializable {
    private static final long serialVersionUID = 905784513600884082L;
    private Map<String, Object> columns;

    void setColumnsMap(Map<String, Object> columns) {
        this.columns = columns;
    }

    public Record remove(String column) {
        this.getColumns().remove(column);
        return this;
    }

    public Map<String, Object> getColumns() {
        return this.columns;
    }

    public Record setColumns(Map<String, Object> columns) {
        this.getColumns().putAll(columns);
        return this;
    }

    public Record setColumns(Record record) {
        this.getColumns().putAll(record.getColumns());
        return this;
    }

    public Record remove(String ... columns) {
        if (columns != null) {
            for (String c : columns) {
                this.getColumns().remove(c);
            }
        }
        return this;
    }

    public Record removeNullValueColumns() {
        Iterator<Map.Entry<String, Object>> it = this.getColumns().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> e = it.next();
            if (e.getValue() != null) continue;
            it.remove();
        }
        return this;
    }

    public Record keep(String ... columns) {
        if (columns != null && columns.length > 0) {
            HashMap<String, Object> newColumns = new HashMap<String, Object>(columns.length);
            for (String c : columns) {
                if (!this.getColumns().containsKey(c)) continue;
                newColumns.put(c, this.getColumns().get(c));
            }
            this.getColumns().clear();
            this.getColumns().putAll(newColumns);
        } else {
            this.getColumns().clear();
        }
        return this;
    }

    public Record keep(String column) {
        if (this.getColumns().containsKey(column)) {
            Object keepIt = this.getColumns().get(column);
            this.getColumns().clear();
            this.getColumns().put(column, keepIt);
        } else {
            this.getColumns().clear();
        }
        return this;
    }

    public Record clear() {
        this.getColumns().clear();
        return this;
    }

    public Record set(String column, Object value) {
        this.getColumns().put(column, value);
        return this;
    }

    public <T> T get(String column) {
        return (T)this.getColumns().get(column);
    }

    public <T> T get(String column, Object defaultValue) {
        Object result = this.getColumns().get(column);
        return (T)(result != null ? result : defaultValue);
    }

    public Object getObject(String column) {
        return this.getColumns().get(column);
    }

    public Object getObject(String column, Object defaultValue) {
        Object result = this.getColumns().get(column);
        return result != null ? result : defaultValue;
    }

    public String getStr(String column) {
        Object s = this.getColumns().get(column);
        return s != null ? s.toString() : null;
    }

    public Integer getInt(String column) {
        Number n = this.getNumber(column);
        return n != null ? Integer.valueOf(n.intValue()) : null;
    }

    public Number getNumber(String column) {
        return (Number)this.getColumns().get(column);
    }

    public Long getLong(String column) {
        Number n = this.getNumber(column);
        return n != null ? Long.valueOf(n.longValue()) : null;
    }

    public BigInteger getBigInteger(String column) {
        return (BigInteger)this.getColumns().get(column);
    }

    public Date getDate(String column) {
        Object ret = this.getColumns().get(column);
        if (ret instanceof Temporal) {
            if (ret instanceof LocalDateTime) {
                return DateUtil.date((TemporalAccessor)((LocalDateTime)ret));
            }
            if (ret instanceof LocalDate) {
                return DateUtil.date((TemporalAccessor)((LocalDate)ret));
            }
            if (ret instanceof LocalTime) {
                return DateUtil.date((TemporalAccessor)((LocalTime)ret));
            }
        }
        return (Date)ret;
    }

    public LocalDateTime getLocalDateTime(String column) {
        Object ret = this.getColumns().get(column);
        if (ret instanceof LocalDateTime) {
            return (LocalDateTime)ret;
        }
        if (ret instanceof LocalDate) {
            return ((LocalDate)ret).atStartOfDay();
        }
        if (ret instanceof LocalTime) {
            return LocalDateTime.of(LocalDate.now(), (LocalTime)ret);
        }
        if (ret instanceof Date) {
            return DateUtil.toLocalDateTime((Date)((Date)ret));
        }
        return (LocalDateTime)ret;
    }

    public Time getTime(String column) {
        return (Time)this.getColumns().get(column);
    }

    public Timestamp getTimestamp(String column) {
        return (Timestamp)this.getColumns().get(column);
    }

    public Double getDouble(String column) {
        Number n = this.getNumber(column);
        return n != null ? Double.valueOf(n.doubleValue()) : null;
    }

    public Float getFloat(String column) {
        Number n = this.getNumber(column);
        return n != null ? Float.valueOf(n.floatValue()) : null;
    }

    public Short getShort(String column) {
        Number n = this.getNumber(column);
        return n != null ? Short.valueOf(n.shortValue()) : null;
    }

    public Byte getByte(String column) {
        Number n = this.getNumber(column);
        return n != null ? Byte.valueOf(n.byteValue()) : null;
    }

    public Boolean getBoolean(String column) {
        return (Boolean)this.getColumns().get(column);
    }

    public BigDecimal getBigDecimal(String column) {
        Object n = this.getColumns().get(column);
        if (n instanceof BigDecimal) {
            return (BigDecimal)n;
        }
        if (n != null) {
            return new BigDecimal(n.toString());
        }
        return null;
    }

    public byte[] getBytes(String column) {
        return (byte[])this.getColumns().get(column);
    }

    public int hashCode() {
        return this.getColumns().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Record)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        return this.getColumns().equals(((Record)o).getColumns());
    }

    public String toString() {
        if (this.columns == null) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        boolean first = true;
        for (Map.Entry<String, Object> e : this.getColumns().entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            Object value = e.getValue();
            if (value != null) {
                value = value.toString();
            }
            sb.append(e.getKey()).append(':').append(value);
        }
        sb.append('}');
        return sb.toString();
    }

    public String[] getColumnNames() {
        Set<String> attrNameSet = this.getColumns().keySet();
        return attrNameSet.toArray(new String[attrNameSet.size()]);
    }

    public Object[] getColumnValues() {
        Collection<Object> attrValueCollection = this.getColumns().values();
        return attrValueCollection.toArray(new Object[attrValueCollection.size()]);
    }

    public String toJson() {
        return JackSonUtil.toJson(this.getColumns());
    }
}

