/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.common.page;

import java.io.Serializable;
import java.util.List;

public class Page<T>
implements Serializable {
    private static final long serialVersionUID = -7102129155309986923L;
    protected List<T> records;
    protected long total;
    protected long size;
    protected long current;
    protected long pages;

    public Page(long current, long size, long total, List<T> records) {
        this.records = records;
        this.total = total;
        this.size = size;
        this.current = current;
    }

    private long getPages() {
        if (this.getSize() == 0L) {
            return 0L;
        }
        long pages = this.getTotal() / this.getSize();
        if (this.getTotal() % this.getSize() != 0L) {
            ++pages;
        }
        return pages;
    }

    public List<T> getRecords() {
        return this.records;
    }

    public long getTotal() {
        return this.total;
    }

    public long getSize() {
        return this.size;
    }

    public long getCurrent() {
        return this.current;
    }

    public void setRecords(List<T> records) {
        this.records = records;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setCurrent(long current) {
        this.current = current;
    }

    public void setPages(long pages) {
        this.pages = pages;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Page)) {
            return false;
        }
        Page other = (Page)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.getCurrent() != other.getCurrent()) {
            return false;
        }
        if (this.getPages() != other.getPages()) {
            return false;
        }
        List<T> this$records = this.getRecords();
        List<T> other$records = other.getRecords();
        return !(this$records == null ? other$records != null : !((Object)this$records).equals(other$records));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Page;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $total = this.getTotal();
        result = result * 59 + (int)($total >>> 32 ^ $total);
        long $size = this.getSize();
        result = result * 59 + (int)($size >>> 32 ^ $size);
        long $current = this.getCurrent();
        result = result * 59 + (int)($current >>> 32 ^ $current);
        long $pages = this.getPages();
        result = result * 59 + (int)($pages >>> 32 ^ $pages);
        List<T> $records = this.getRecords();
        result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
        return result;
    }

    public String toString() {
        return "Page(records=" + this.getRecords() + ", total=" + this.getTotal() + ", size=" + this.getSize() + ", current=" + this.getCurrent() + ", pages=" + this.getPages() + ")";
    }
}

