/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.common.util;

import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JackSonUtil {
    public static final Logger LOGGER = LoggerFactory.getLogger(JackSonUtil.class);
    public static final ObjectMapper JSON = new ObjectMapper();

    public static String toJson(Object o) {
        if (Objects.isNull(o)) {
            return null;
        }
        try {
            return JSON.writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("toJson \u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            return "";
        }
    }

    public static <T> T toObject(String str, Class<T> cs) {
        if (StrUtil.isBlank((CharSequence)str)) {
            return null;
        }
        try {
            return (T)JSON.readValue(str, cs);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("toObject \u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static <T> List<T> toObjectList(String str, Class<T> clsChild) {
        if (StrUtil.isBlank((CharSequence)str)) {
            return null;
        }
        try {
            JavaType javaType = JSON.getTypeFactory().constructParametricType(List.class, new Class[]{clsChild});
            return (List)JSON.readValue(str, javaType);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("toObjectList \u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static <T> List<T> toObjectListByType(String str) {
        if (StrUtil.isBlank((CharSequence)str)) {
            return null;
        }
        try {
            TypeReference type = new TypeReference<List<T>>(){};
            return (List)JSON.readValue(str, type);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("toObjectListByType \u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static <T> Map<String, T> toObjectMap(String str, Class<T> vCls) {
        if (StrUtil.isBlank((CharSequence)str)) {
            return null;
        }
        try {
            JavaType javaType = JSON.getTypeFactory().constructParametricType(Map.class, new Class[]{String.class, vCls});
            return (Map)JSON.readValue(str, javaType);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("toObjectMap \u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static Map<String, Object> toMap(String str) {
        if (StrUtil.isBlank((CharSequence)str)) {
            return null;
        }
        try {
            return (Map)JSON.readValue(str, Map.class);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("toMap \u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    static {
        JSON.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        JSON.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JSON.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    }
}

