/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.common.util;

import cn.hutool.crypto.asymmetric.AsymmetricAlgorithm;
import cn.hutool.crypto.asymmetric.AsymmetricCrypto;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.RSA;
import com.efficient.common.entity.KeyPair;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class RsaUtil {
    public static String encrypt(String data, String publicKeyStr) {
        RSA rsa = new RSA(null, publicKeyStr);
        byte[] encrypt = rsa.encrypt(data.getBytes(StandardCharsets.UTF_8), KeyType.PublicKey);
        return Base64.getEncoder().encodeToString(encrypt);
    }

    public static String decrypt(String data, String privateKeyStr) {
        RSA rsa = new RSA(privateKeyStr, null);
        byte[] decrypt = rsa.decrypt(Base64.getDecoder().decode(data.getBytes(StandardCharsets.UTF_8)), KeyType.PrivateKey);
        return new String(decrypt, StandardCharsets.UTF_8);
    }

    public static String encryptReversal(String data, String privateKeyStr) {
        RSA rsa = new RSA(privateKeyStr, null);
        byte[] encrypt = rsa.encrypt(data.getBytes(StandardCharsets.UTF_8), KeyType.PrivateKey);
        return Base64.getEncoder().encodeToString(encrypt);
    }

    public static String decryptReversal(String data, String publicKeyStr) {
        RSA rsa = new RSA(null, publicKeyStr);
        byte[] decrypt = rsa.decrypt(Base64.getDecoder().decode(data.getBytes(StandardCharsets.UTF_8)), KeyType.PublicKey);
        return new String(decrypt, StandardCharsets.UTF_8);
    }

    public static KeyPair generateKeyPair() {
        AsymmetricCrypto rsa = new AsymmetricCrypto(AsymmetricAlgorithm.RSA);
        byte[] publicKey = rsa.getPublicKey().getEncoded();
        byte[] privateKey = rsa.getPrivateKey().getEncoded();
        String publicKeyStr = cn.hutool.core.codec.Base64.encode((byte[])publicKey);
        String privateKeyStr = cn.hutool.core.codec.Base64.encode((byte[])privateKey);
        return KeyPair.builder().publicKey(publicKeyStr).privateKey(privateKeyStr).build();
    }
}

