/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.common.util;

import com.alibaba.ttl.threadpool.TtlExecutors;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class ThreadUtil {
    private static final Logger LOGGER = Logger.getLogger(ThreadUtil.class.getName());
    public static final ExecutorService EXECUTOR_SERVICE = TtlExecutors.getTtlExecutorService((ExecutorService)MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(12, 12, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ThreadUtil-%d").setUncaughtExceptionHandler((t, e) -> {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        LOGGER.warning("\u4efb\u52a1\u5904\u7406\u5f02\u5e38!" + sw);
    }).setThreadFactory(Thread::new).build(), new ThreadPoolExecutor.CallerRunsPolicy())));

    private static void shutdownThreadPoolGracefully() {
        EXECUTOR_SERVICE.shutdown();
        try {
            if (!EXECUTOR_SERVICE.awaitTermination(60L, TimeUnit.SECONDS)) {
                EXECUTOR_SERVICE.shutdownNow();
                if (!EXECUTOR_SERVICE.awaitTermination(60L, TimeUnit.SECONDS)) {
                    LOGGER.warning("\u7ebf\u7a0b\u6c60\u672a\u4f18\u96c5\u5173\u95ed");
                }
            }
        }
        catch (InterruptedException ie) {
            EXECUTOR_SERVICE.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(ThreadUtil::shutdownThreadPoolGracefully));
    }
}

