/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.configs.config;

import com.efficient.common.exception.DataSecurityException;
import com.efficient.common.result.Result;
import com.efficient.common.result.ResultConstant;
import com.efficient.common.result.ResultEnum;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class GlobalExceptionHandler {
    public static final Logger LOGGER = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={Exception.class, Throwable.class})
    @ResponseBody
    public Result<?> handler(Exception e) {
        LOGGER.error("error: {}", (Object)e.getMessage(), (Object)e);
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return Result.build((ResultConstant)ResultEnum.ERROR, (Object)sw.toString());
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseBody
    public Result<?> handler(ConstraintViolationException ex) {
        String message = ex.getConstraintViolations().stream().map(ConstraintViolation::getMessage).collect(Collectors.joining());
        return this.validateResultFormat(message);
    }

    private <T extends Throwable> Result<?> validateResultFormat(String message) {
        return Result.build((ResultConstant)ResultEnum.PARA_ERROR, (Object)message);
    }

    @ExceptionHandler(value={BindException.class})
    @ResponseBody
    public Result<?> handler(BindException ex) {
        String message = ex.getBindingResult().getAllErrors().stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.joining());
        return this.validateResultFormat(message);
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseBody
    public Result<?> handler(HttpRequestMethodNotSupportedException ex) {
        String message = ex.getMessage();
        return this.validateResultFormat(message);
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseBody
    public Result<?> handler(MissingServletRequestParameterException ex) {
        String parameterName = ex.getParameterName();
        return this.validateResultFormat("\u53c2\u6570\u7f3a\u5931\uff1a" + parameterName);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    public Result<?> handler(MethodArgumentNotValidException ex) {
        String message = ex.getBindingResult().getAllErrors().stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.joining());
        return this.validateResultFormat(message);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @ResponseBody
    public Result<?> httpMessageNotReadableException(HttpMessageNotReadableException ex) {
        return Result.build((ResultConstant)ResultEnum.ERROR, (Object)String.format("\u53c2\u6570\u683c\u5f0f\u65e0\u6548:%s", ex));
    }

    @ExceptionHandler(value={DataSecurityException.class})
    @ResponseBody
    public Result<?> dataSecurityException(DataSecurityException ex) {
        return Result.build((ResultConstant)ResultEnum.DATA_SECURITY);
    }
}

