/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.configs.config;

import com.efficient.configs.api.StartedEventServer;
import com.efficient.swagger.properties.SwaggerProperties;
import com.efficient.system.api.DictCodeService;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

@Component
public class StartedEvent
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(StartedEvent.class);
    @Autowired
    private DictCodeService dictCodeService;
    @Autowired(required=false)
    private StartedEventServer startedEventServer;
    @Value(value="${server.port:8080}")
    private Integer port;
    @Value(value="${server.servlet.context-path:}")
    private String contextPath;
    @Autowired
    private SwaggerProperties swaggerProperties;

    public void run(ApplicationArguments args) throws Exception {
        if (Objects.nonNull(this.startedEventServer)) {
            log.info("Start StartedEventServer ...... ");
            this.startedEventServer.init();
        }
        this.dictCodeService.init();
        log.info("System startup successful !");
        if (this.swaggerProperties.getEnable().booleanValue()) {
            String serverAddress = "http://localhost:" + this.port + this.contextPath + "/swagger-ui/index.html";
            log.info("swagger doc url: {}", (Object)serverAddress);
        }
    }
}

