/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.configs.config;

import cn.hutool.core.collection.CollUtil;
import com.efficient.auth.interceptor.PermissionInterceptor;
import com.efficient.auth.properties.AuthProperties;
import com.efficient.logs.interceptor.RequestHolderInterceptor;
import com.efficient.rate.interceptor.RateInterceptor;
import com.efficient.rate.properties.RateProperties;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebMvcConfig
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(WebMvcConfig.class);
    @Autowired
    private RequestHolderInterceptor requestHolderInterceptor;
    @Autowired
    private PermissionInterceptor permissionInterceptor;
    @Autowired
    private AuthProperties authProperties;
    @Autowired
    private RateInterceptor rateInterceptor;
    @Autowired
    private RateProperties rateProperties;

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.requestHolderInterceptor).addPathPatterns(new String[]{"/**"});
        List whiteList = this.authProperties.getWhiteList();
        registry.addInterceptor((HandlerInterceptor)this.permissionInterceptor).addPathPatterns(new String[]{"/**"}).excludePathPatterns(whiteList);
        List methodList = this.rateProperties.getMethodList();
        List excludeApiList = this.rateProperties.getExcludeApiList();
        if (CollUtil.isEmpty((Collection)excludeApiList)) {
            registry.addInterceptor((HandlerInterceptor)this.rateInterceptor).addPathPatterns(methodList);
        } else {
            registry.addInterceptor((HandlerInterceptor)this.rateInterceptor).addPathPatterns(methodList).excludePathPatterns(excludeApiList);
        }
    }
}

