/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.configs.config;

import com.baomidou.mybatisplus.annotation.DbType;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DatabaseConfig {
    private static final Logger log = LoggerFactory.getLogger(DatabaseConfig.class);
    @Autowired
    private DataSource dataSource;
    private String databaseProductName;

    @PostConstruct
    public void init() {
        try (Connection connection = this.dataSource.getConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            this.databaseProductName = metaData.getDatabaseProductName();
        }
        catch (SQLException e) {
            log.error("\u83b7\u53d6\u6570\u636e\u5e93\u914d\u7f6e\u5f02\u5e38", (Throwable)e);
        }
    }

    public DbType getDbType() {
        return DbType.getDbType((String)this.databaseProductName);
    }
}

