/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.configs.service;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.efficient.common.util.JackSonUtil;
import com.efficient.configs.api.WebSocketHandleApi;
import com.efficient.configs.model.dto.WebSocketReceiveDTO;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"com.efficient.configs.webSocket.enable"}, havingValue="true")
@ServerEndpoint(value="/ws/{id}")
public class WebSocketService {
    private static final Logger log = LoggerFactory.getLogger(WebSocketService.class);
    private static int onlineCount = 0;
    private static ConcurrentHashMap<String, WebSocketService> webSocketMap = new ConcurrentHashMap();
    private static WebSocketHandleApi webSocketHandleApi;
    private Session session;
    private String id = "";

    @Autowired
    public void setUserService(WebSocketHandleApi webSocketHandleApi) {
        WebSocketService.webSocketHandleApi = webSocketHandleApi;
    }

    public void sendInfo(String message, @PathParam(value="id") String id) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)id) && webSocketMap.containsKey(id)) {
            webSocketMap.get(id).sendMessage(message);
        } else {
            log.error("WebSocket:\u76ee\u6807ID[" + id + "]\u4e0d\u5b58\u5728\uff0c\u53d1\u9001\u5931\u8d25\uff01");
        }
    }

    public void sendMessage(String message) throws IOException {
        this.session.getBasicRemote().sendText(message);
    }

    public synchronized int getOnLineCount() {
        return onlineCount;
    }

    @OnOpen
    public void onOpen(Session session, @PathParam(value="id") String id) {
        this.session = session;
        this.id = id;
        if (webSocketMap.containsKey(id)) {
            webSocketMap.remove(id);
            webSocketMap.put(id, this);
        } else {
            webSocketMap.put(id, this);
            this.addOnlineCount();
        }
        log.info("WebSocket:\u7528\u6237[" + id + "]\u5df2\u8fde\u63a5\u5230WS\u670d\u52a1\u5668\uff01");
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("type", "register");
            this.sendMessage(JackSonUtil.toJson(map));
        }
        catch (IOException e) {
            log.error("WebSocket:\u7528\u6237\u7f51\u7edc\u5f02\u5e38\uff0c\u53d1\u9001\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    public synchronized void addOnlineCount() {
        ++onlineCount;
    }

    @OnMessage
    public void onMessage(String message, Session session) {
        log.info("WebSocket:\u63a5\u6536\u5230\u7528\u6237[" + this.id + "]\u53d1\u9001\u6d88\u606f\uff0c\u62a5\u6587\uff1a" + message);
        if (StringUtils.isNotBlank((CharSequence)message)) {
            try {
                WebSocketReceiveDTO receiveDTO = (WebSocketReceiveDTO)JackSonUtil.toObject((String)message, WebSocketReceiveDTO.class);
                String receiveDTOMessage = receiveDTO.getMessage();
                List<String> toIdList = receiveDTO.getToIdList();
                if (CollUtil.isNotEmpty(toIdList)) {
                    toIdList.stream().filter(et -> webSocketMap.containsKey(et)).forEach(et -> {
                        try {
                            webSocketMap.get(et).sendMessage(receiveDTOMessage);
                        }
                        catch (IOException e) {
                            log.error("WebSocket:\u76ee\u6807ID[" + et + "]\u4e0d\u5b58\u5728\uff0c\u53d1\u9001\u5931\u8d25\uff01", (Throwable)e);
                        }
                    });
                } else {
                    webSocketHandleApi.receive(receiveDTOMessage);
                }
            }
            catch (Exception e) {
                log.error("WebSocket \u63a5\u6536\u6d88\u606f\u5904\u7406\u5f02\u5e38\uff01", (Throwable)e);
            }
        }
    }

    @OnError
    public void onError(Session session, Throwable error) {
        log.error("WebSocket:\u7528\u6237\u9519\u8bef", error);
    }

    @OnClose
    public void onClose() {
        if (webSocketMap.containsKey(this.id)) {
            webSocketMap.remove(this.id);
            WebSocketService.subOnlineCount();
        }
        log.info("WebSocket:\u7528\u6237[" + this.id + "]\u5df2\u65ad\u5f00WS\u670d\u52a1\u5668\u8fde\u63a5\uff01");
    }

    public static synchronized void subOnlineCount() {
        --onlineCount;
    }
}

