/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.data.security.db.crypt;

import cn.hutool.core.util.StrUtil;
import com.efficient.data.security.db.crypt.Crypt;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DbAES
implements Crypt {
    private static final Logger log = LoggerFactory.getLogger(DbAES.class);
    private static final String AES_ALGORITHM = "AES/ECB/PKCS5Padding";
    public static String dbEncryptKey;
    public static boolean dbEncryptEnable;
    public static String dbEncryptModelPath;

    @Override
    public String encrypt(String data) {
        if (!dbEncryptEnable || StrUtil.isBlank((CharSequence)data)) {
            return data;
        }
        try {
            Cipher cipher = DbAES.getCipher(dbEncryptKey, 1);
            return Base64.getEncoder().encodeToString(cipher.doFinal(data.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            log.error("DB\u5c42\u6570\u636e\u52a0\u89e3\u5bc6\u5f02\u5e38:" + data, (Throwable)e);
            return data;
        }
    }

    private static Cipher getCipher(String key, int model) throws Exception {
        SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), "AES");
        Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
        cipher.init(model, secretKeySpec);
        return cipher;
    }

    @Override
    public String decrypt(String data) {
        if (!dbEncryptEnable || StrUtil.isBlank((CharSequence)data)) {
            return data;
        }
        try {
            Cipher cipher = DbAES.getCipher(dbEncryptKey, 2);
            return new String(cipher.doFinal(Base64.getDecoder().decode(data.getBytes(StandardCharsets.UTF_8))));
        }
        catch (Exception e) {
            log.error("DB\u5c42\u6570\u636e\u52a0\u89e3\u5bc6\u5f02\u5e38:" + data, (Throwable)e);
            return data;
        }
    }

    @Value(value="${com.efficient.security.db.dbEncryptKey:http://tanmw.top}")
    private void setDbEncryptKey(String dbEncryptKey) {
        DbAES.dbEncryptKey = dbEncryptKey;
    }

    @Value(value="${com.efficient.security.db.dbEncryptEnable:false}")
    private void setDbEncryptEnable(boolean dbEncryptEnable) {
        DbAES.dbEncryptEnable = dbEncryptEnable;
    }

    @Value(value="${com.efficient.security.db.dbEncryptModelPath:top.tanmw.demo.model}")
    private void setDbEncryptModelPath(String dbEncryptModelPath) {
        DbAES.dbEncryptModelPath = dbEncryptModelPath;
    }
}

