/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.data.security.filter;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.efficient.data.security.annotation.RequestDecrypt;
import com.efficient.data.security.annotation.SecuritySkip;
import com.efficient.data.security.constant.EnableType;
import com.efficient.data.security.properties.DataSecurityProperties;
import com.efficient.data.security.util.AESUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class RequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger(RequestWrapper.class);
    private final byte[] body;
    private final Map<String, String[]> parameterMap = new HashMap<String, String[]>();
    private final AESUtils aesUtils;
    private final Method method;

    public RequestWrapper(HttpServletRequest request, AESUtils aesUtils, DataSecurityProperties properties, Method method) {
        super(request);
        String bodyStr = this.getBodyString((ServletRequest)request);
        this.body = bodyStr.getBytes(StandardCharsets.UTF_8);
        this.aesUtils = aesUtils;
        this.method = method;
        if (StrUtil.equals((CharSequence)request.getMethod(), (CharSequence)"GET")) {
            SecuritySkip skip = method.getAnnotation(SecuritySkip.class);
            if (Objects.nonNull(skip) && skip.skipRequest()) {
                return;
            }
            if (Objects.equals((Object)properties.getRequestEnableType(), (Object)EnableType.NEED) && Objects.nonNull(method.getAnnotation(RequestDecrypt.class))) {
                this.decryptParam();
            } else if (Objects.equals((Object)properties.getRequestEnableType(), (Object)EnableType.NODE)) {
                this.decryptParam();
            }
        }
    }

    public String getBodyString(ServletRequest request) {
        try {
            return this.inputStream2String((InputStream)request.getInputStream());
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void decryptParam() {
        Set keySet = super.getParameterMap().keySet();
        for (String key : keySet) {
            Map<String, String[]> urlParams = null;
            urlParams = this.getUrlParams(this.aesUtils.decrypt(key));
            this.parameterMap.putAll(urlParams);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String inputStream2String(InputStream inputStream) {
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.error("", (Throwable)e);
                }
            }
        }
        return sb.toString();
    }

    public Map<String, String[]> getUrlParams(String param) {
        String[] params;
        LinkedHashMap<String, String[]> paramMap = new LinkedHashMap<String, String[]>(10);
        if (StringUtils.isEmpty((Object)param)) {
            return paramMap;
        }
        for (String paramStr : params = param.split("&")) {
            String[] p = paramStr.split("=");
            if (p.length != 2) continue;
            String key = p[0];
            if (paramMap.containsKey(key)) {
                paramMap.put(key, CollUtil.newArrayList((Object[])new Serializable[]{(Serializable)paramMap.get(key), URLUtil.decode((String)p[1])}).toArray(new String[0]));
                continue;
            }
            paramMap.put(key, new String[]{URLUtil.decode((String)p[1])});
        }
        return paramMap;
    }

    public String[] getParameterValues(String name) {
        String[] result = super.getParameterValues(name);
        if (result == null && this.parameterMap.containsKey(name)) {
            result = this.parameterMap.get(name);
        }
        return result;
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameterMap;
    }

    public BufferedReader getReader() {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public ServletInputStream getInputStream() {
        final ByteArrayInputStream inputStream = new ByteArrayInputStream(this.body);
        return new ServletInputStream(){

            public int read() {
                return inputStream.read();
            }

            public int available() throws IOException {
                return inputStream.available();
            }

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }
        };
    }
}

