/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.data.security.handler;

import com.efficient.common.exception.DataSecurityException;
import com.efficient.data.security.annotation.RequestDecrypt;
import com.efficient.data.security.annotation.SecuritySkip;
import com.efficient.data.security.constant.EnableType;
import com.efficient.data.security.properties.DataSecurityProperties;
import com.efficient.data.security.util.AESUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdviceAdapter;

@ConditionalOnProperty(name={"com.efficient.data.requestEnable"}, havingValue="true")
@ControllerAdvice
public class RequestDataSecurity
extends RequestBodyAdviceAdapter {
    @Autowired
    private DataSecurityProperties properties;
    @Autowired
    private AESUtils aesUtils;

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        SecuritySkip skip = (SecuritySkip)methodParameter.getMethodAnnotation(SecuritySkip.class);
        if (Objects.nonNull(skip) && skip.skipRequest()) {
            return false;
        }
        if (Objects.equals((Object)this.properties.getRequestEnableType(), (Object)EnableType.NEED)) {
            return methodParameter.hasMethodAnnotation(RequestDecrypt.class);
        }
        return Objects.equals((Object)this.properties.getRequestEnableType(), (Object)EnableType.NODE);
    }

    public HttpInputMessage beforeBodyRead(final HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) throws IOException {
        byte[] body = new byte[inputMessage.getBody().available()];
        inputMessage.getBody().read(body);
        try {
            byte[] decrypt = this.aesUtils.decrypt(body);
            final ByteArrayInputStream data = new ByteArrayInputStream(decrypt);
            return new HttpInputMessage(){

                public InputStream getBody() {
                    return data;
                }

                public HttpHeaders getHeaders() {
                    return inputMessage.getHeaders();
                }
            };
        }
        catch (Exception e) {
            throw new DataSecurityException((Throwable)e);
        }
    }
}

