/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.data.security.util;

import com.efficient.data.security.properties.DataSecurityProperties;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AESUtils {
    private static final Logger log = LoggerFactory.getLogger(AESUtils.class);
    private static final String AES_ALGORITHM = "AES/ECB/PKCS5Padding";
    @Autowired
    private DataSecurityProperties properties;

    public String encrypt(byte[] data) {
        try {
            Cipher cipher = AESUtils.getCipher(this.properties.getEncryptKey(), 1);
            return Base64.getEncoder().encodeToString(cipher.doFinal(data));
        }
        catch (Exception e) {
            throw new RuntimeException("\u6570\u636e\u52a0\u89e3\u5bc6\u5f02\u5e38", e);
        }
    }

    public String encrypt(String data) {
        try {
            Cipher cipher = AESUtils.getCipher(this.properties.getEncryptKey(), 1);
            return Base64.getEncoder().encodeToString(cipher.doFinal(data.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            throw new RuntimeException("\u6570\u636e\u52a0\u89e3\u5bc6\u5f02\u5e38", e);
        }
    }

    private static Cipher getCipher(String key, int model) throws Exception {
        SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), "AES");
        Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
        cipher.init(model, secretKeySpec);
        return cipher;
    }

    public byte[] decrypt(byte[] data) {
        try {
            Cipher cipher = AESUtils.getCipher(this.properties.getEncryptKey(), 2);
            return cipher.doFinal(Base64.getDecoder().decode(data));
        }
        catch (Exception e) {
            throw new RuntimeException("\u6570\u636e\u52a0\u89e3\u5bc6\u5f02\u5e38", e);
        }
    }

    public String decrypt(String data) {
        try {
            Cipher cipher = AESUtils.getCipher(this.properties.getEncryptKey(), 2);
            return new String(cipher.doFinal(Base64.getDecoder().decode(data.getBytes(StandardCharsets.UTF_8))));
        }
        catch (Exception e) {
            throw new RuntimeException("\u6570\u636e\u52a0\u89e3\u5bc6\u5f02\u5e38", e);
        }
    }
}

